"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jsonValidator = exports.OAuth2Fields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _additional_fields = require("../components/additional_fields");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/common/auth/oauth2_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const jsonValidator = ({
  value
}) => {
  if (!value) {
    return undefined;
  }
  try {
    const parsedValue = JSON.parse(value);
    if (typeof parsedValue !== 'object') {
      return {
        message: i18n.INVALID_JSON
      };
    }
    if (Array.isArray(parsedValue)) {
      return {
        message: i18n.INVALID_INPUT_ARRAY
      };
    }
    if (parsedValue === null || Object.keys(parsedValue).length === 0) {
      return {
        message: i18n.INVALID_INPUT_EMPTY
      };
    }
    return undefined;
  } catch (e) {
    return {
      message: i18n.INVALID_JSON
    };
  }
};
exports.jsonValidator = jsonValidator;
const AdditionalFieldsWrapper = /*#__PURE__*/_react.default.memo(({
  field,
  readOnly,
  isOptionalField
}) => {
  const {
    value,
    setValue
  } = field;
  const {
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const handleAdditionalFieldsChange = (0, _react.useCallback)(json => {
    setValue(json);
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_additional_fields.AdditionalFields, {
    value: value,
    onChange: handleAdditionalFieldsChange,
    errors: errorMessage ? [errorMessage] : undefined,
    isOptionalField: isOptionalField,
    readOnly: readOnly,
    helpText: i18n.ADDITIONAL_FIELDS_HELP_WEBHOOK_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  });
});
const OAuth2Fields = ({
  readOnly
}) => {
  const {
    emptyField,
    urlField
  } = _helpers.fieldValidators;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    "data-test-subj": "basicAuthFields",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.accessTokenUrl",
    config: {
      label: i18n.ACCESS_TOKEN_URL,
      validations: [{
        validator: urlField(i18n.ACCESS_TOKEN_URL_REQUIRED)
      }]
    },
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'accessTokenUrlAOuth2',
        fullWidth: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.clientId",
    config: {
      label: i18n.CLIENT_ID,
      validations: [{
        validator: emptyField(i18n.CLIENT_ID_REQUIRED)
      }]
    },
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'clientIdOAuth2',
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.clientSecret",
    config: {
      label: i18n.CLIENT_SECRET,
      validations: [{
        validator: emptyField(i18n.CLIENT_SECRET_REQUIRED)
      }]
    },
    component: _components.PasswordField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'clientSecretOAuth2',
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.scope",
    config: {
      label: i18n.SCOPE,
      helpText: i18n.SCOPE_HELP_TEXT,
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 15
        }
      }, i18n.OPTIONAL_LABEL)
    },
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'ScopeOAuth2',
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.additionalFields",
    config: {
      label: i18n.ADDITIONAL_FIELDS,
      validations: [{
        validator: jsonValidator
      }]
    },
    component: AdditionalFieldsWrapper,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'AdditionalFieldsOAuth2'
      },
      isOptionalField: true,
      readOnly
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  })));
};
exports.OAuth2Fields = OAuth2Fields;