"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemtryMetadataSchema = exports.StreamingResponseSchema = exports.SecretsSchema = exports.RunApiResponseSchema = exports.RunActionResponseSchema = exports.RunActionRawResponseSchema = exports.RunActionParamsSchema = exports.InvokeAIRawActionResponseSchema = exports.InvokeAIRawActionParamsSchema = exports.InvokeAIActionResponseSchema = exports.InvokeAIActionParamsSchema = exports.DashboardActionResponseSchema = exports.DashboardActionParamsSchema = exports.ConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TelemtryMetadataSchema = exports.TelemtryMetadataSchema = _configSchema.schema.object({
  pluginId: _configSchema.schema.maybe(_configSchema.schema.string()),
  aggregateBy: _configSchema.schema.maybe(_configSchema.schema.string())
});
const ConfigSchema = exports.ConfigSchema = _configSchema.schema.object({
  apiUrl: _configSchema.schema.string(),
  defaultModel: _configSchema.schema.string({
    defaultValue: _constants.DEFAULT_GEMINI_MODEL
  }),
  gcpRegion: _configSchema.schema.string(),
  gcpProjectID: _configSchema.schema.string(),
  contextWindowLength: _configSchema.schema.maybe(_configSchema.schema.number({}))
});
const SecretsSchema = exports.SecretsSchema = _configSchema.schema.object({
  credentialsJson: _configSchema.schema.string()
});
const RunActionParamsSchema = exports.RunActionParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.any(),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number()),
  temperature: _configSchema.schema.maybe(_configSchema.schema.number()),
  stopSequences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  raw: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  telemetryMetadata: _configSchema.schema.maybe(TelemtryMetadataSchema)
});
const RunApiResponseSchema = exports.RunApiResponseSchema = _configSchema.schema.object({
  candidates: _configSchema.schema.any(),
  usageMetadata: _configSchema.schema.object({
    promptTokenCount: _configSchema.schema.number(),
    candidatesTokenCount: _configSchema.schema.number(),
    totalTokenCount: _configSchema.schema.number()
  })
}, {
  unknowns: 'ignore'
} // unknown keys will NOT fail validation, but will be removed
);
const RunActionResponseSchema = exports.RunActionResponseSchema = _configSchema.schema.object({
  completion: _configSchema.schema.string(),
  stop_reason: _configSchema.schema.maybe(_configSchema.schema.string()),
  usageMetadata: _configSchema.schema.maybe(_configSchema.schema.object({
    promptTokenCount: _configSchema.schema.number(),
    candidatesTokenCount: _configSchema.schema.number(),
    totalTokenCount: _configSchema.schema.number()
  }))
}, {
  unknowns: 'ignore'
});
const RunActionRawResponseSchema = exports.RunActionRawResponseSchema = _configSchema.schema.any();
const InvokeAIActionParamsSchema = exports.InvokeAIActionParamsSchema = _configSchema.schema.object({
  maxOutputTokens: _configSchema.schema.maybe(_configSchema.schema.number()),
  messages: _configSchema.schema.any(),
  systemInstruction: _configSchema.schema.maybe(_configSchema.schema.string()),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  temperature: _configSchema.schema.maybe(_configSchema.schema.number()),
  stopSequences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number()),
  tools: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  toolConfig: _configSchema.schema.maybe(_configSchema.schema.object({
    mode: _configSchema.schema.oneOf([_configSchema.schema.literal('AUTO'), _configSchema.schema.literal('ANY'), _configSchema.schema.literal('NONE')]),
    allowedFunctionNames: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  })),
  telemetryMetadata: _configSchema.schema.maybe(TelemtryMetadataSchema)
});
const InvokeAIRawActionParamsSchema = exports.InvokeAIRawActionParamsSchema = _configSchema.schema.object({
  maxOutputTokens: _configSchema.schema.maybe(_configSchema.schema.number()),
  messages: _configSchema.schema.any(),
  systemInstruction: _configSchema.schema.maybe(_configSchema.schema.string()),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  temperature: _configSchema.schema.maybe(_configSchema.schema.number()),
  stopSequences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number()),
  tools: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  telemetryMetadata: _configSchema.schema.maybe(TelemtryMetadataSchema)
});
const InvokeAIActionResponseSchema = exports.InvokeAIActionResponseSchema = _configSchema.schema.object({
  message: _configSchema.schema.string(),
  usageMetadata: _configSchema.schema.maybe(_configSchema.schema.object({
    promptTokenCount: _configSchema.schema.number(),
    candidatesTokenCount: _configSchema.schema.number(),
    totalTokenCount: _configSchema.schema.number()
  }))
});
const InvokeAIRawActionResponseSchema = exports.InvokeAIRawActionResponseSchema = _configSchema.schema.any();
const StreamingResponseSchema = exports.StreamingResponseSchema = _configSchema.schema.any();
const DashboardActionParamsSchema = exports.DashboardActionParamsSchema = _configSchema.schema.object({
  dashboardId: _configSchema.schema.string()
});
const DashboardActionResponseSchema = exports.DashboardActionResponseSchema = _configSchema.schema.object({
  available: _configSchema.schema.boolean()
});