"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.GEMINI_TITLE = exports.GEMINI_CONNECTOR_ID = exports.DEFAULT_TOKEN_LIMIT = exports.DEFAULT_TIMEOUT_MS = exports.DEFAULT_GEMINI_URL = exports.DEFAULT_GEMINI_MODEL = exports.DEFAULT_GCP_REGION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GEMINI_TITLE = exports.GEMINI_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.gemini.connectorTypeTitle', {
  defaultMessage: 'Google Gemini'
});
const GEMINI_CONNECTOR_ID = exports.GEMINI_CONNECTOR_ID = '.gemini';
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["RUN"] = "run";
  SUB_ACTION["DASHBOARD"] = "getDashboard";
  SUB_ACTION["TEST"] = "test";
  SUB_ACTION["INVOKE_AI"] = "invokeAI";
  SUB_ACTION["INVOKE_AI_RAW"] = "invokeAIRaw";
  SUB_ACTION["INVOKE_STREAM"] = "invokeStream";
  return SUB_ACTION;
}({});
const DEFAULT_TOKEN_LIMIT = exports.DEFAULT_TOKEN_LIMIT = 8192;
const DEFAULT_TIMEOUT_MS = exports.DEFAULT_TIMEOUT_MS = 60000;
const DEFAULT_GCP_REGION = exports.DEFAULT_GCP_REGION = 'us-central1';
const DEFAULT_GEMINI_MODEL = exports.DEFAULT_GEMINI_MODEL = 'gemini-2.5-pro';
const DEFAULT_GEMINI_URL = exports.DEFAULT_GEMINI_URL = `https://us-central1-aiplatform.googleapis.com`;