"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelaxedCrowdstrikeBaseApiResponseSchema = exports.CrowdstrikeSecretsSchema = exports.CrowdstrikeRTRCommandParamsSchema = exports.CrowdstrikeInitRTRResponseSchema = exports.CrowdstrikeInitRTRParamsSchema = exports.CrowdstrikeHostActionsSchema = exports.CrowdstrikeHostActionsResponseSchema = exports.CrowdstrikeHostActionsParamsSchema = exports.CrowdstrikeGetTokenResponseSchema = exports.CrowdstrikeGetScriptsResponseSchema = exports.CrowdstrikeGetAgentsResponseSchema = exports.CrowdstrikeGetAgentsParamsSchema = exports.CrowdstrikeGetAgentOnlineStatusResponseSchema = exports.CrowdstrikeExecuteRTRResponseSchema = exports.CrowdstrikeConfigSchema = exports.CrowdstrikeBaseApiResponseSchema = exports.CrowdstrikeApiDoNotValidateResponsesSchema = exports.CrowdstrikeActionParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Connector schema
const CrowdstrikeConfigSchema = exports.CrowdstrikeConfigSchema = _configSchema.schema.object({
  url: _configSchema.schema.string()
});
const CrowdstrikeSecretsSchema = exports.CrowdstrikeSecretsSchema = _configSchema.schema.object({
  clientId: _configSchema.schema.string(),
  clientSecret: _configSchema.schema.string()
});
const CrowdstrikeApiDoNotValidateResponsesSchema = exports.CrowdstrikeApiDoNotValidateResponsesSchema = _configSchema.schema.any();
const RelaxedCrowdstrikeBaseApiResponseSchema = exports.RelaxedCrowdstrikeBaseApiResponseSchema = _configSchema.schema.maybe(_configSchema.schema.object({}, {
  unknowns: 'allow'
}));
const CrowdstrikeBaseApiResponseSchema = exports.CrowdstrikeBaseApiResponseSchema = _configSchema.schema.object({
  resources: _configSchema.schema.arrayOf(_configSchema.schema.any()),
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  meta: _configSchema.schema.object({
    query_time: _configSchema.schema.maybe(_configSchema.schema.number()),
    powered_by: _configSchema.schema.maybe(_configSchema.schema.string()),
    trace_id: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  })
}, {
  unknowns: 'allow'
});
const CrowdstrikeGetAgentOnlineStatusResponseSchema = exports.CrowdstrikeGetAgentOnlineStatusResponseSchema = _configSchema.schema.object({
  resources: _configSchema.schema.arrayOf(_configSchema.schema.object({
    state: _configSchema.schema.maybe(_configSchema.schema.string()),
    id: _configSchema.schema.maybe(_configSchema.schema.string()),
    last_seen: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  })),
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  meta: _configSchema.schema.object({
    query_time: _configSchema.schema.maybe(_configSchema.schema.number()),
    powered_by: _configSchema.schema.maybe(_configSchema.schema.string()),
    trace_id: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  })
}, {
  unknowns: 'allow'
});
const CrowdstrikeGetAgentsResponseSchema = exports.CrowdstrikeGetAgentsResponseSchema = _configSchema.schema.object({
  resources: _configSchema.schema.arrayOf(_configSchema.schema.object({
    device_id: _configSchema.schema.maybe(_configSchema.schema.string()),
    cid: _configSchema.schema.maybe(_configSchema.schema.string()),
    agent_load_flags: _configSchema.schema.maybe(_configSchema.schema.string()),
    agent_local_time: _configSchema.schema.maybe(_configSchema.schema.string()),
    agent_version: _configSchema.schema.maybe(_configSchema.schema.string()),
    bios_manufacturer: _configSchema.schema.maybe(_configSchema.schema.string()),
    bios_version: _configSchema.schema.maybe(_configSchema.schema.string()),
    config_id_base: _configSchema.schema.maybe(_configSchema.schema.string()),
    config_id_build: _configSchema.schema.maybe(_configSchema.schema.string()),
    config_id_platform: _configSchema.schema.maybe(_configSchema.schema.string()),
    cpu_signature: _configSchema.schema.maybe(_configSchema.schema.string()),
    cpu_vendor: _configSchema.schema.maybe(_configSchema.schema.string()),
    external_ip: _configSchema.schema.maybe(_configSchema.schema.string()),
    mac_address: _configSchema.schema.maybe(_configSchema.schema.string()),
    instance_id: _configSchema.schema.maybe(_configSchema.schema.string()),
    service_provider: _configSchema.schema.maybe(_configSchema.schema.string()),
    service_provider_account_id: _configSchema.schema.maybe(_configSchema.schema.string()),
    hostname: _configSchema.schema.maybe(_configSchema.schema.string()),
    first_seen: _configSchema.schema.maybe(_configSchema.schema.string()),
    last_login_timestamp: _configSchema.schema.maybe(_configSchema.schema.string()),
    last_login_user: _configSchema.schema.maybe(_configSchema.schema.string()),
    last_login_uid: _configSchema.schema.maybe(_configSchema.schema.string()),
    last_seen: _configSchema.schema.maybe(_configSchema.schema.string()),
    local_ip: _configSchema.schema.maybe(_configSchema.schema.string()),
    major_version: _configSchema.schema.maybe(_configSchema.schema.string()),
    minor_version: _configSchema.schema.maybe(_configSchema.schema.string()),
    os_version: _configSchema.schema.maybe(_configSchema.schema.string()),
    platform_id: _configSchema.schema.maybe(_configSchema.schema.string()),
    platform_name: _configSchema.schema.maybe(_configSchema.schema.string()),
    policies: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      policy_type: _configSchema.schema.maybe(_configSchema.schema.string()),
      policy_id: _configSchema.schema.maybe(_configSchema.schema.string()),
      applied: _configSchema.schema.maybe(_configSchema.schema.boolean()),
      settings_hash: _configSchema.schema.maybe(_configSchema.schema.string()),
      assigned_date: _configSchema.schema.maybe(_configSchema.schema.string()),
      applied_date: _configSchema.schema.maybe(_configSchema.schema.string()),
      rule_groups: _configSchema.schema.maybe(_configSchema.schema.any())
    }, {
      unknowns: 'allow'
    }))),
    reduced_functionality_mode: _configSchema.schema.maybe(_configSchema.schema.string()),
    device_policies: _configSchema.schema.maybe(_configSchema.schema.object({
      prevention: _configSchema.schema.object({
        policy_type: _configSchema.schema.maybe(_configSchema.schema.string()),
        policy_id: _configSchema.schema.maybe(_configSchema.schema.string()),
        applied: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        settings_hash: _configSchema.schema.maybe(_configSchema.schema.string()),
        assigned_date: _configSchema.schema.maybe(_configSchema.schema.string()),
        applied_date: _configSchema.schema.maybe(_configSchema.schema.string()),
        rule_groups: _configSchema.schema.maybe(_configSchema.schema.any())
      }, {
        unknowns: 'allow'
      }),
      sensor_update: _configSchema.schema.object({
        policy_type: _configSchema.schema.maybe(_configSchema.schema.string()),
        policy_id: _configSchema.schema.maybe(_configSchema.schema.string()),
        applied: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        settings_hash: _configSchema.schema.maybe(_configSchema.schema.string()),
        assigned_date: _configSchema.schema.maybe(_configSchema.schema.string()),
        applied_date: _configSchema.schema.maybe(_configSchema.schema.string()),
        uninstall_protection: _configSchema.schema.maybe(_configSchema.schema.string())
      }, {
        unknowns: 'allow'
      }),
      global_config: _configSchema.schema.object({
        policy_type: _configSchema.schema.maybe(_configSchema.schema.string()),
        policy_id: _configSchema.schema.maybe(_configSchema.schema.string()),
        applied: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        settings_hash: _configSchema.schema.maybe(_configSchema.schema.string()),
        assigned_date: _configSchema.schema.maybe(_configSchema.schema.string()),
        applied_date: _configSchema.schema.maybe(_configSchema.schema.string())
      }, {
        unknowns: 'allow'
      }),
      remote_response: _configSchema.schema.object({
        policy_type: _configSchema.schema.maybe(_configSchema.schema.string()),
        policy_id: _configSchema.schema.maybe(_configSchema.schema.string()),
        applied: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        settings_hash: _configSchema.schema.maybe(_configSchema.schema.string()),
        assigned_date: _configSchema.schema.maybe(_configSchema.schema.string()),
        applied_date: _configSchema.schema.maybe(_configSchema.schema.string())
      }, {
        unknowns: 'allow'
      })
    }, {
      unknowns: 'allow'
    })),
    groups: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
    group_hash: _configSchema.schema.maybe(_configSchema.schema.string()),
    product_type_desc: _configSchema.schema.maybe(_configSchema.schema.string()),
    provision_status: _configSchema.schema.maybe(_configSchema.schema.string()),
    serial_number: _configSchema.schema.maybe(_configSchema.schema.string()),
    status: _configSchema.schema.maybe(_configSchema.schema.string()),
    system_manufacturer: _configSchema.schema.maybe(_configSchema.schema.string()),
    system_product_name: _configSchema.schema.maybe(_configSchema.schema.string()),
    tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
    modified_timestamp: _configSchema.schema.any(),
    meta: _configSchema.schema.maybe(_configSchema.schema.object({
      version: _configSchema.schema.maybe(_configSchema.schema.string()),
      version_string: _configSchema.schema.maybe(_configSchema.schema.string())
    }, {
      unknowns: 'allow'
    })),
    zone_group: _configSchema.schema.maybe(_configSchema.schema.string()),
    kernel_version: _configSchema.schema.maybe(_configSchema.schema.string()),
    chassis_type: _configSchema.schema.maybe(_configSchema.schema.string()),
    chassis_type_desc: _configSchema.schema.maybe(_configSchema.schema.string()),
    connection_ip: _configSchema.schema.maybe(_configSchema.schema.string()),
    default_gateway_ip: _configSchema.schema.maybe(_configSchema.schema.string()),
    connection_mac_address: _configSchema.schema.maybe(_configSchema.schema.string()),
    linux_sensor_mode: _configSchema.schema.maybe(_configSchema.schema.string()),
    deployment_type: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  })),
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  meta: _configSchema.schema.object({
    query_time: _configSchema.schema.maybe(_configSchema.schema.number()),
    powered_by: _configSchema.schema.maybe(_configSchema.schema.string()),
    trace_id: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  })
}, {
  unknowns: 'allow'
});
const CrowdstrikeHostActionsResponseSchema = exports.CrowdstrikeHostActionsResponseSchema = _configSchema.schema.object({
  resources: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.maybe(_configSchema.schema.string()),
    path: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  })),
  meta: _configSchema.schema.object({
    query_time: _configSchema.schema.maybe(_configSchema.schema.number()),
    powered_by: _configSchema.schema.maybe(_configSchema.schema.string()),
    trace_id: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  }),
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.any()))
}, {
  unknowns: 'allow'
});

// TODO temporary any value
const CrowdstrikeRTRCommandParamsSchema = exports.CrowdstrikeRTRCommandParamsSchema = _configSchema.schema.any();
const CrowdstrikeHostActionsParamsSchema = exports.CrowdstrikeHostActionsParamsSchema = _configSchema.schema.object({
  command: _configSchema.schema.oneOf([_configSchema.schema.literal('contain'), _configSchema.schema.literal('lift_containment')]),
  actionParameters: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  })),
  ids: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  alertIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  comment: _configSchema.schema.maybe(_configSchema.schema.string())
});
const CrowdstrikeGetAgentsParamsSchema = exports.CrowdstrikeGetAgentsParamsSchema = _configSchema.schema.object({
  ids: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const CrowdstrikeGetTokenResponseSchema = exports.CrowdstrikeGetTokenResponseSchema = _configSchema.schema.object({
  access_token: _configSchema.schema.string(),
  expires_in: _configSchema.schema.number(),
  token_type: _configSchema.schema.string(),
  id_token: _configSchema.schema.maybe(_configSchema.schema.string()),
  issued_token_type: _configSchema.schema.maybe(_configSchema.schema.string()),
  refresh_token: _configSchema.schema.maybe(_configSchema.schema.string()),
  scope: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'allow'
});
const CrowdstrikeHostActionsSchema = exports.CrowdstrikeHostActionsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.HOST_ACTIONS),
  subActionParams: CrowdstrikeHostActionsParamsSchema
});
const CrowdstrikeActionParamsSchema = exports.CrowdstrikeActionParamsSchema = _configSchema.schema.oneOf([CrowdstrikeHostActionsSchema]);
const CrowdstrikeInitRTRResponseSchema = exports.CrowdstrikeInitRTRResponseSchema = _configSchema.schema.object({
  meta: _configSchema.schema.maybe(_configSchema.schema.object({
    query_time: _configSchema.schema.maybe(_configSchema.schema.number()),
    powered_by: _configSchema.schema.maybe(_configSchema.schema.string()),
    trace_id: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  })),
  batch_id: _configSchema.schema.maybe(_configSchema.schema.string()),
  resources: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    session_id: _configSchema.schema.maybe(_configSchema.schema.string()),
    task_id: _configSchema.schema.maybe(_configSchema.schema.string()),
    complete: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    stdout: _configSchema.schema.maybe(_configSchema.schema.string()),
    stderr: _configSchema.schema.maybe(_configSchema.schema.string()),
    base_command: _configSchema.schema.maybe(_configSchema.schema.string()),
    aid: _configSchema.schema.maybe(_configSchema.schema.string()),
    errors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
    query_time: _configSchema.schema.maybe(_configSchema.schema.number()),
    offline_queued: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }, {
    unknowns: 'allow'
  }))),
  errors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any()))
}, {
  unknowns: 'allow'
});
const CrowdstrikeInitRTRParamsSchema = exports.CrowdstrikeInitRTRParamsSchema = _configSchema.schema.object({
  endpoint_ids: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const CrowdstrikeExecuteRTRResponseSchema = exports.CrowdstrikeExecuteRTRResponseSchema = _configSchema.schema.object({
  combined: _configSchema.schema.object({
    resources: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
      session_id: _configSchema.schema.string(),
      task_id: _configSchema.schema.string(),
      complete: _configSchema.schema.boolean(),
      stdout: _configSchema.schema.string(),
      stderr: _configSchema.schema.string(),
      base_command: _configSchema.schema.string(),
      aid: _configSchema.schema.string(),
      errors: _configSchema.schema.arrayOf(_configSchema.schema.any()),
      query_time: _configSchema.schema.number(),
      offline_queued: _configSchema.schema.boolean()
    }, {
      unknowns: 'allow'
    }))
  }, {
    unknowns: 'allow'
  }),
  meta: _configSchema.schema.object({
    query_time: _configSchema.schema.number(),
    powered_by: _configSchema.schema.string(),
    trace_id: _configSchema.schema.string()
  }, {
    unknowns: 'allow'
  }),
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.any()))
}, {
  unknowns: 'allow'
});
const CrowdstrikeGetScriptsResponseSchema = exports.CrowdstrikeGetScriptsResponseSchema = _configSchema.schema.object({
  meta: _configSchema.schema.maybe(_configSchema.schema.object({
    query_time: _configSchema.schema.maybe(_configSchema.schema.number()),
    powered_by: _configSchema.schema.maybe(_configSchema.schema.string()),
    trace_id: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  })),
  resources: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    content: _configSchema.schema.maybe(_configSchema.schema.string()),
    created_by: _configSchema.schema.maybe(_configSchema.schema.string()),
    created_by_uuid: _configSchema.schema.maybe(_configSchema.schema.string()),
    created_timestamp: _configSchema.schema.maybe(_configSchema.schema.string()),
    file_type: _configSchema.schema.maybe(_configSchema.schema.string()),
    id: _configSchema.schema.maybe(_configSchema.schema.string()),
    description: _configSchema.schema.maybe(_configSchema.schema.string()),
    modified_by: _configSchema.schema.maybe(_configSchema.schema.string()),
    modified_timestamp: _configSchema.schema.maybe(_configSchema.schema.string()),
    name: _configSchema.schema.maybe(_configSchema.schema.string()),
    permission_type: _configSchema.schema.maybe(_configSchema.schema.string()),
    platform: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    run_attempt_count: _configSchema.schema.maybe(_configSchema.schema.number()),
    run_success_count: _configSchema.schema.maybe(_configSchema.schema.number()),
    sha256: _configSchema.schema.maybe(_configSchema.schema.string()),
    size: _configSchema.schema.maybe(_configSchema.schema.number()),
    write_access: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }, {
    unknowns: 'allow'
  }))),
  errors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any()))
}, {
  unknowns: 'allow'
});