"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WebhookMethods = exports.SSLCertType = exports.MAX_HEADERS = exports.AuthType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AuthType = exports.AuthType = /*#__PURE__*/function (AuthType) {
  AuthType["Basic"] = "webhook-authentication-basic";
  AuthType["SSL"] = "webhook-authentication-ssl";
  AuthType["OAuth2ClientCredentials"] = "webhook-oauth2-client-credentials";
  return AuthType;
}({});
let SSLCertType = exports.SSLCertType = /*#__PURE__*/function (SSLCertType) {
  SSLCertType["CRT"] = "ssl-crt-key";
  SSLCertType["PFX"] = "ssl-pfx";
  return SSLCertType;
}({});
let WebhookMethods = exports.WebhookMethods = /*#__PURE__*/function (WebhookMethods) {
  WebhookMethods["PATCH"] = "patch";
  WebhookMethods["DELETE"] = "delete";
  WebhookMethods["POST"] = "post";
  WebhookMethods["PUT"] = "put";
  WebhookMethods["GET"] = "get";
  return WebhookMethods;
}({});
const MAX_HEADERS = exports.MAX_HEADERS = 20;