"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateServerless = validateServerless;
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateServerless(params) {
  const {
    size
  } = params;
  if (size > _common.ES_QUERY_MAX_HITS_PER_EXECUTION_SERVERLESS) {
    throw new Error(_i18n.i18n.translate('xpack.stackAlerts.esQuery.serverless.sizeErrorMessage', {
      defaultMessage: '[size]: must be less than or equal to {maxSize}',
      values: {
        maxSize: _common.ES_QUERY_MAX_HITS_PER_EXECUTION_SERVERLESS
      }
    }));
  }
}