"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsQueryExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _codeEditor = require("@kbn/code-editor");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _common = require("@kbn/alerting-plugin/common");
var _common2 = require("@kbn/triggers-actions-ui-plugin/public/common");
var _common3 = require("../../../../common");
var _validation = require("../validation");
var _build_sorted_events_query = require("../../../../common/build_sorted_events_query");
var _types = require("../types");
var _index_select_popover = require("../../components/index_select_popover");
var _constants = require("../constants");
var _rule_common_expressions = require("../rule_common_expressions");
var _util = require("../util");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/es_query/expression/es_query_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  useXJsonMode
} = _public.XJson;
const EsQueryExpression = ({
  ruleParams,
  setRuleParams,
  setRuleProperty,
  errors,
  data
}) => {
  const services = (0, _util.useTriggerUiActionServices)();
  const {
    http,
    docLinks,
    isServerless
  } = services;
  const {
    index,
    timeField,
    esQuery,
    size,
    thresholdComparator,
    threshold,
    timeWindowSize,
    timeWindowUnit,
    aggType,
    aggField,
    groupBy,
    termSize,
    termField,
    excludeHitsFromPreviousRun
  } = ruleParams;
  const [currentRuleParams, setCurrentRuleParams] = (0, _react.useState)({
    ...ruleParams,
    timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : _constants.DEFAULT_VALUES.TIME_WINDOW_SIZE,
    timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : _constants.DEFAULT_VALUES.TIME_WINDOW_UNIT,
    threshold: threshold !== null && threshold !== void 0 ? threshold : _constants.DEFAULT_VALUES.THRESHOLD,
    thresholdComparator: thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    size: size !== null && size !== void 0 ? size : isServerless ? _constants.SERVERLESS_DEFAULT_VALUES.SIZE : _constants.DEFAULT_VALUES.SIZE,
    esQuery: esQuery !== null && esQuery !== void 0 ? esQuery : _constants.DEFAULT_VALUES.QUERY,
    aggType: aggType !== null && aggType !== void 0 ? aggType : _constants.DEFAULT_VALUES.AGGREGATION_TYPE,
    groupBy: groupBy !== null && groupBy !== void 0 ? groupBy : _constants.DEFAULT_VALUES.GROUP_BY,
    termSize: termSize !== null && termSize !== void 0 ? termSize : _constants.DEFAULT_VALUES.TERM_SIZE,
    searchType: _types.SearchType.esQuery,
    excludeHitsFromPreviousRun: excludeHitsFromPreviousRun !== null && excludeHitsFromPreviousRun !== void 0 ? excludeHitsFromPreviousRun : _constants.DEFAULT_VALUES.EXCLUDE_PREVIOUS_HITS,
    // The sourceFields param is ignored
    sourceFields: []
  });
  const setParam = (0, _react.useCallback)((paramField, paramValue) => {
    setCurrentRuleParams(currentParams => ({
      ...currentParams,
      [paramField]: paramValue
    }));
    setRuleParams(paramField, paramValue);
  }, [setRuleParams]);
  const [esFields, setEsFields] = (0, _react.useState)([]);
  const [runtimeFields, setRuntimeFields] = (0, _react.useState)([]);
  const [combinedFields, setCombinedFields] = (0, _react.useState)([]);
  const {
    convertToJson,
    setXJson,
    xJson
  } = useXJsonMode(_constants.DEFAULT_VALUES.QUERY);
  const setDefaultExpressionValues = async () => {
    setRuleProperty('params', currentRuleParams);
    const query = esQuery !== null && esQuery !== void 0 ? esQuery : _constants.DEFAULT_VALUES.QUERY;
    setXJson(query);
    if (index && index.length > 0) {
      const initialRuntimeFields = getRuntimeFields(query);
      await refreshEsFields(index, initialRuntimeFields);
    }
  };
  (0, _react.useEffect)(() => {
    setDefaultExpressionValues();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const refreshEsFields = async (indices, initialRuntimeFields) => {
    const currentEsFields = await (0, _public2.getFields)(http, indices);
    setEsFields(currentEsFields);
    const combined = currentEsFields.concat(initialRuntimeFields !== undefined ? initialRuntimeFields : runtimeFields);
    setCombinedFields((0, _lodash.sortBy)(combined, 'name'));
  };
  const getRuntimeFields = xjson => {
    let runtimeMappings;
    try {
      runtimeMappings = (0, _lodash.get)(JSON.parse(xjson), 'runtime_mappings');
    } catch (e) {
      // ignore error
    }
    if (runtimeMappings) {
      const currentRuntimeFields = (0, _util.convertRawRuntimeFieldtoFieldOption)(runtimeMappings);
      setRuntimeFields(currentRuntimeFields);
      setCombinedFields((0, _lodash.sortBy)(esFields.concat(currentRuntimeFields), 'name'));
      return currentRuntimeFields;
    }
  };
  const onTestQuery = (0, _react.useCallback)(async () => {
    const isGroupAgg = (0, _common2.isGroupAggregation)(termField);
    const isCountAgg = (0, _common2.isCountAggregation)(aggType);
    const window = `${timeWindowSize}${timeWindowUnit}`;
    if ((0, _validation.hasExpressionValidationErrors)(currentRuleParams, isServerless)) {
      return {
        testResults: {
          results: [],
          truncated: false
        },
        isGrouped: isGroupAgg,
        timeWindow: window
      };
    }
    const timeWindow = (0, _common.parseDuration)(window);
    const parsedQuery = JSON.parse(esQuery);
    const now = Date.now();
    const {
      rawResponse
    } = await (0, _rxjs.lastValueFrom)(data.search.search({
      params: (0, _build_sorted_events_query.buildSortedEventsQuery)({
        index,
        from: new Date(now - timeWindow).toISOString(),
        to: new Date(now).toISOString(),
        filter: parsedQuery.query,
        size: 0,
        searchAfterSortId: undefined,
        timeField: timeField ? timeField : '',
        track_total_hits: true,
        aggs: (0, _common2.buildAggregation)({
          aggType,
          aggField,
          termField,
          termSize,
          condition: {
            conditionScript: (0, _common3.getComparatorScript)(thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR, threshold, _common2.BUCKET_SELECTOR_FIELD)
          }
        })
      })
    }));
    return {
      testResults: (0, _common2.parseAggregationResults)({
        isCountAgg,
        isGroupAgg,
        esResult: rawResponse
      }),
      isGrouped: isGroupAgg,
      timeWindow: window
    };
  }, [timeWindowSize, timeWindowUnit, currentRuleParams, esQuery, data.search, index, timeField, aggType, aggField, termField, termSize, threshold, thresholdComparator, isServerless]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": "indexSelectPopover",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.selectIndexPrompt",
      defaultMessage: "Select indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_index_select_popover.IndexSelectPopover, {
    index: index,
    esFields: esFields,
    timeField: timeField,
    errors: errors,
    onIndexChange: async indices => {
      setParam('index', indices);

      // reset expression fields if indices are deleted
      if (indices.length === 0) {
        setRuleProperty('params', {
          timeField: ruleParams.timeField,
          index: indices,
          esQuery: _constants.DEFAULT_VALUES.QUERY,
          size: _constants.DEFAULT_VALUES.SIZE,
          thresholdComparator: _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
          timeWindowSize: _constants.DEFAULT_VALUES.TIME_WINDOW_SIZE,
          timeWindowUnit: _constants.DEFAULT_VALUES.TIME_WINDOW_UNIT,
          threshold: _constants.DEFAULT_VALUES.THRESHOLD,
          aggType: _constants.DEFAULT_VALUES.AGGREGATION_TYPE,
          groupBy: _constants.DEFAULT_VALUES.GROUP_BY,
          termSize: _constants.DEFAULT_VALUES.TERM_SIZE,
          searchType: _types.SearchType.esQuery,
          excludeHitsFromPreviousRun: _constants.DEFAULT_VALUES.EXCLUDE_PREVIOUS_HITS,
          sourceFields: undefined
        });
      } else {
        await refreshEsFields(indices);
      }
    },
    onTimeFieldChange: updatedTimeField => setParam('timeField', updatedTimeField),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "queryEditor",
    "data-test-subj": "queryJsonEditor",
    fullWidth: true
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.esQuery.length > 0,
    error: errors.esQuery,
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.query.queryDsl,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.queryPrompt.help",
      defaultMessage: "Elasticsearch Query DSL documentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 13
      }
    })),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.defineQueryPrompt",
      defaultMessage: "Define your query using Query DSL",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "xjson",
    width: "100%",
    height: "200px",
    value: xJson,
    onChange: xjson => {
      setXJson(xjson);
      setParam('esQuery', convertToJson(xjson));
      getRuntimeFields(xjson);
    },
    options: {
      ariaLabel: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.queryEditor', {
        defaultMessage: 'Elasticsearch query editor'
      }),
      wordWrap: 'off',
      tabSize: 2,
      lineNumbers: 'off',
      lineNumbersMinChars: 0,
      folding: false,
      lineDecorationsWidth: 0,
      overviewRulerBorder: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_rule_common_expressions.RuleCommonExpressions, {
    threshold: threshold !== null && threshold !== void 0 ? threshold : _constants.DEFAULT_VALUES.THRESHOLD,
    thresholdComparator: thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    timeWindowSize: timeWindowSize,
    timeWindowUnit: timeWindowUnit,
    size: size,
    esFields: combinedFields,
    aggType: aggType,
    aggField: aggField,
    groupBy: groupBy,
    termSize: termSize,
    termField: termField,
    onChangeSelectedAggField: (0, _react.useCallback)(selectedAggField => setParam('aggField', selectedAggField), [setParam]),
    onChangeSelectedAggType: (0, _react.useCallback)(selectedAggType => setParam('aggType', selectedAggType), [setParam]),
    onChangeSelectedGroupBy: (0, _react.useCallback)(selectedGroupBy => setParam('groupBy', selectedGroupBy), [setParam]),
    onChangeSelectedTermField: (0, _react.useCallback)(selectedTermField => setParam('termField', selectedTermField), [setParam]),
    onChangeSelectedTermSize: (0, _react.useCallback)(selectedTermSize => setParam('termSize', selectedTermSize), [setParam]),
    onChangeThreshold: (0, _react.useCallback)(selectedThresholds => setParam('threshold', selectedThresholds), [setParam]),
    onChangeThresholdComparator: (0, _react.useCallback)(selectedThresholdComparator => setParam('thresholdComparator', selectedThresholdComparator), [setParam]),
    onChangeWindowSize: (0, _react.useCallback)(selectedWindowSize => setParam('timeWindowSize', selectedWindowSize), [setParam]),
    onChangeWindowUnit: (0, _react.useCallback)(selectedWindowUnit => setParam('timeWindowUnit', selectedWindowUnit), [setParam]),
    onChangeSizeValue: (0, _react.useCallback)(updatedValue => setParam('size', updatedValue), [setParam]),
    errors: errors,
    hasValidationErrors: (0, _validation.hasExpressionValidationErrors)(currentRuleParams, isServerless),
    onTestFetch: onTestQuery,
    excludeHitsFromPreviousRun: excludeHitsFromPreviousRun !== null && excludeHitsFromPreviousRun !== void 0 ? excludeHitsFromPreviousRun : _constants.DEFAULT_VALUES.EXCLUDE_PREVIOUS_HITS,
    onChangeExcludeHitsFromPreviousRun: (0, _react.useCallback)(exclude => setParam('excludeHitsFromPreviousRun', exclude), [setParam]),
    canSelectMultiTerms: _constants.DEFAULT_VALUES.CAN_SELECT_MULTI_TERMS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 7
    }
  }));
};
exports.EsQueryExpression = EsQueryExpression;