"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesContextWrapperInternal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _context = require("./context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/spaces_context/wrapper_internal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
async function getSpacesData(spacesManager, feature) {
  const spaces = await spacesManager.getSpaces({
    includeAuthorizedPurposes: true
  });
  const activeSpace = await spacesManager.getActiveSpace();
  const spacesMap = spaces.map(({
    authorizedPurposes,
    disabledFeatures,
    ...space
  }) => {
    const isActiveSpace = space.id === activeSpace.id;
    const isFeatureDisabled = feature !== undefined && disabledFeatures.includes(feature);
    return {
      ...space,
      ...(isActiveSpace && {
        isActiveSpace
      }),
      ...(isFeatureDisabled && {
        isFeatureDisabled
      }),
      isAuthorizedForPurpose: purpose =>
      // If authorizedPurposes is not present, then Security is disabled; normally in a situation like this we would "fail-secure", but
      // in this case we are dealing with an abstraction over the client-side UI capabilities. There is no chance for privilege
      // escalation here, and the correct behavior is that if Security is disabled, the user is implicitly authorized to do everything.
      authorizedPurposes ? authorizedPurposes[purpose] === true : true
    };
  }).reduce((acc, cur) => acc.set(cur.id, cur), new Map());
  return {
    spacesMap,
    activeSpaceId: activeSpace.id
  };
}
const SpacesContextWrapperInternal = props => {
  const {
    spacesManager,
    getStartServices,
    feature,
    children
  } = props;
  const [context, setContext] = (0, _react.useState)();
  const spacesDataPromise = (0, _react.useMemo)(() => getSpacesData(spacesManager, feature), [spacesManager, feature]);
  (0, _react.useEffect)(() => {
    let unmounted = false;
    getStartServices().then(([coreStart]) => {
      if (unmounted) {
        return;
      }
      const {
        application,
        docLinks,
        notifications
      } = coreStart;
      const services = {
        application,
        docLinks,
        notifications
      };
      setContext((0, _context.createSpacesReactContext)(services, spacesManager, spacesDataPromise));
    });
    return () => {
      unmounted = true;
    };
  }, [getStartServices, spacesDataPromise, spacesManager]);
  if (!context) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(context.Provider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 10
    }
  }, children);
};
exports.SpacesContextWrapperInternal = SpacesContextWrapperInternal;