"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEditableRole = exports.SpaceAssignedRolesTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lib = require("../../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/management/edit_space/roles/component/space_assigned_roles_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isRoleReserved = role => {
  var _role$metadata;
  return (_role$metadata = role.metadata) === null || _role$metadata === void 0 ? void 0 : _role$metadata._reserved;
};
const isRoleAssignedToAll = role => {
  return role.kibana.reduce((acc, cur) => {
    return cur.spaces.includes('*') || acc;
  }, false);
};

/**
 * @description checks if the passed role qualifies as one that can
 * be edited by a user with sufficient permissions
 */
const isEditableRole = role => {
  return !(isRoleReserved(role) || isRoleAssignedToAll(role));
};
exports.isEditableRole = isEditableRole;
const getTableColumns = ({
  isReadOnly,
  currentSpace,
  onClickRowEditAction,
  onClickRemoveRoleConfirm
}) => {
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.name.title', {
      defaultMessage: 'Role'
    }),
    width: '45%'
  }, {
    field: 'privileges',
    name: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.privileges.title', {
      defaultMessage: 'Privileges'
    }),
    render: (_, record) => {
      const uniquePrivilege = new Set(record.kibana.reduce((privilegeBaseTuple, kibanaPrivilege) => {
        if (kibanaPrivilege.spaces.includes(currentSpace.id) || kibanaPrivilege.spaces.includes('*')) {
          if (!kibanaPrivilege.base.length) {
            privilegeBaseTuple.push(_i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.privileges.customPrivilege', {
              defaultMessage: 'custom'
            }));
          } else {
            return privilegeBaseTuple.concat(kibanaPrivilege.base);
          }
        }
        return privilegeBaseTuple;
      }, []));
      return Array.from(uniquePrivilege).join(',');
    }
  }, {
    field: 'metadata',
    name: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.roleType.title', {
      defaultMessage: 'Role type'
    }),
    render: _value => {
      return _value !== null && _value !== void 0 && _value._reserved ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        children: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.roleType.reserved', {
          defaultMessage: 'Reserved'
        }),
        color: 'primary'
      }) : null;
    }
  }];
  if (!isReadOnly) {
    columns.push({
      name: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.actions.columnHeaderName', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        render: role => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: isRoleReserved(role) ? _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.actions.notEditableDescription.isReserved', {
              defaultMessage: 'This role is reserved.'
            }) : _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.actions.notEditableDescription.isAssignedToAll', {
              defaultMessage: 'This role is assigned to all spaces. To change this, go to Roles.'
            }),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 147,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            iconType: "lock",
            disabled: true,
            "data-test-subj": "spaceRoleCellActionLocked",
            "aria-label": isRoleReserved(role) ? _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.actions.notEditableTitle.isReserved', {
              defaultMessage: 'Reserved'
            }) : _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.actions.notEditableTitle.isAssignedToAll', {
              defaultMessage: 'Assigned to all spaces'
            }),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 163,
              columnNumber: 17
            }
          }));
        },
        showOnHover: true,
        enabled: () => false,
        available: rowRecord => !isEditableRole(rowRecord)
      }, {
        type: 'icon',
        icon: 'pencil',
        isPrimary: true,
        'data-test-subj': 'spaceRoleCellEditAction',
        name: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.actions.edit.title', {
          defaultMessage: 'Remove from space'
        }),
        description: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.actions.edit.description', {
          defaultMessage: 'Click this action to edit the role privileges of this user for this space.'
        }),
        available: rowRecord => isEditableRole(rowRecord),
        onClick: onClickRowEditAction
      }, {
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        isPrimary: true,
        'data-test-subj': 'spaceRoleCellDeleteAction',
        name: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.actions.remove.title', {
          defaultMessage: 'Remove from space'
        }),
        description: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.column.actions.edit.description', {
          defaultMessage: 'Click this action to remove the user from this space.'
        }),
        available: rowRecord => isEditableRole(rowRecord),
        onClick: onClickRemoveRoleConfirm
      }]
    });
  }
  return columns;
};
const getRowProps = item => {
  const {
    name
  } = item;
  return {
    'data-test-subj': `space-role-row-${name}`,
    onClick: () => {}
  };
};
const getCellProps = (item, column) => {
  const {
    name
  } = item;
  const {
    field
  } = column;
  return {
    'data-test-subj': `space-role-cell-${name}-${String(field)}`,
    textOnly: true
  };
};
const SpaceAssignedRolesTable = ({
  assignedRoles,
  currentSpace,
  onClickAssignNewRole,
  onClickBulkRemove,
  onClickRowEditAction,
  onClickRemoveRoleConfirm,
  isReadOnly = false,
  supportsBulkAction = false
}) => {
  const tableColumns = (0, _react.useMemo)(() => getTableColumns({
    isReadOnly,
    onClickRowEditAction,
    onClickRemoveRoleConfirm,
    currentSpace
  }), [currentSpace, isReadOnly, onClickRowEditAction, onClickRemoveRoleConfirm]);
  const [rolesInView, setRolesInView] = (0, _react.useState)([]);
  const [selectedRoles, setSelectedRoles] = (0, _react.useState)([]);
  const [isBulkActionContextOpen, setBulkActionContextOpen] = (0, _react.useState)(false);
  const [pagination, setPagination] = (0, _react.useState)({
    index: 0,
    size: 10
  });
  (0, _react.useEffect)(() => {
    const valuesFromMap = Array.from(assignedRoles.values());
    const sortedRoles = valuesFromMap.sort(_lib.sortRolesForListing);
    setRolesInView(sortedRoles);
  }, [assignedRoles]);
  const onSearchQueryChange = (0, _react.useCallback)(({
    query
  }) => {
    const assignedRolesTransformed = Array.from(assignedRoles.values());
    const sortedAssignedRolesTransformed = assignedRolesTransformed.sort(_lib.sortRolesForListing);
    if (query !== null && query !== void 0 && query.text) {
      setRolesInView(sortedAssignedRolesTransformed.filter(role => role.name.includes(query.text.toLowerCase())));
    } else {
      setRolesInView(sortedAssignedRolesTransformed);
    }
  }, [assignedRoles]);
  const searchElementDefinition = (0, _react.useMemo)(() => {
    return {
      box: {
        fullWidth: false,
        incremental: true,
        'data-test-subj': 'spaceAssignedRolesSearchBox',
        placeholder: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.searchField.placeholder', {
          defaultMessage: 'Filter assigned roles...'
        })
      },
      onChange: onSearchQueryChange,
      toolsRight: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isReadOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        color: "primary",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 313,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "plusInCircle",
        onClick: onClickAssignNewRole,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 314,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assign', {
        defaultMessage: 'Assign new roles'
      }))))
    };
  }, [isReadOnly, onClickAssignNewRole, onSearchQueryChange]);
  const tableHeader = (0, _react.useMemo)(() => {
    if (!supportsBulkAction) {
      return null;
    }
    const pageSize = pagination.size;
    const pageIndex = pagination.index;
    const selectableRoles = rolesInView.filter(role => isEditableRole(role) && !isReadOnly);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 337,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 338,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 339,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 340,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 341,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 342,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 343,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.selectedStatusInfo', {
      defaultMessage: 'Showing: {pageItemLength} of {rolesInViewCount} | Selected: {selectedCount, plural, one {one role} other {{selectedCount} roles}}',
      values: {
        pageItemLength: Math.floor(rolesInView.length / (pageSize * (pageIndex + 1))) ? pageSize * (pageIndex + 1) : rolesInView.length % pageSize,
        rolesInViewCount: rolesInView.length,
        selectedCount: selectedRoles.length
      }
    }))))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 364,
        columnNumber: 13
      }
    }, !isReadOnly && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 366,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 367,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      isOpen: isBulkActionContextOpen,
      closePopover: setBulkActionContextOpen.bind(null, false),
      anchorPosition: "downCenter",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "s",
        iconSide: "right",
        iconType: "arrowDown",
        disabled: !selectedRoles.length,
        "data-test-subj": "bulkActionsContextMenuOpener",
        onClick: setBulkActionContextOpen.bind(null, true),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 373,
          columnNumber: 25
        }
      }, _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.bulkActions.contextMenuOpener', {
        defaultMessage: 'Bulk actions'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 368,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      size: "s",
      initialPanelId: 0,
      panels: [{
        id: 0,
        size: 's',
        width: 180,
        items: [{
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "trash",
            color: "danger",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 398,
              columnNumber: 39
            }
          }),
          name: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "danger",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 400,
              columnNumber: 35
            }
          }, _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.bulkActions.remove', {
            defaultMessage: 'Remove from space'
          })),
          onClick: async () => {
            onClickBulkRemove === null || onClickBulkRemove === void 0 ? void 0 : onClickBulkRemove(selectedRoles);
            setBulkActionContextOpen(false);
          }
        }]
      }],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 388,
        columnNumber: 23
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 418,
        columnNumber: 19
      }
    }, Boolean(selectableRoles.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: 's',
      ...(Boolean(selectedRoles.length) ? {
        iconType: 'crossInCircle',
        onClick: setSelectedRoles.bind(null, []),
        children: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.clearRolesSelection', {
          defaultMessage: 'Clear selection'
        })
      } : {
        iconType: 'pagesSelect',
        onClick: setSelectedRoles.bind(null, selectableRoles),
        children: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.selectAllRoles', {
          defaultMessage: 'Select {count, plural, one {role} other {all {count} roles}}',
          values: {
            count: selectableRoles.length
          }
        })
      })
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 450,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none",
      style: {
        height: 1
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 451,
        columnNumber: 11
      }
    })));
  }, [pagination.size, pagination.index, rolesInView, selectedRoles, isReadOnly, supportsBulkAction, isBulkActionContextOpen, onClickBulkRemove]);
  const onTableChange = ({
    page
  }) => {
    setPagination(page);
  };
  const onSelectionChange = selection => {
    setSelectedRoles(selection);
  };
  const selection = (0, _react.useMemo)(() => {
    if (!supportsBulkAction) {
      return void 0;
    }
    return {
      selected: selectedRoles,
      selectable: role => isEditableRole(role),
      selectableMessage: (_selectable, role) => {
        if (isRoleReserved(role)) {
          return _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.selectableMessage.isReserved', {
            defaultMessage: `You can't select a role that is reserved`
          });
        }
        if (isRoleAssignedToAll(role)) {
          return _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.selectableMessage.isRoleAssignedToAll', {
            defaultMessage: `You can't select a role that is assigned to all spaces`
          });
        }
        return _i18n.i18n.translate('xpack.spaces.management.spaceDetails.rolesTable.selectableMessage.selectRole', {
          defaultMessage: `Select {roleName}`,
          values: {
            roleName: role.name
          }
        });
      },
      onSelectionChange
    };
  }, [selectedRoles, supportsBulkAction]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 506,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 507,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "spaceAssignedRolesTable",
    search: searchElementDefinition,
    childrenBetween: tableHeader,
    itemId: "name",
    columns: tableColumns,
    items: rolesInView,
    rowProps: getRowProps,
    cellProps: getCellProps,
    selection: selection,
    pagination: {
      pageSize: pagination.size,
      pageIndex: pagination.index,
      pageSizeOptions: [50, 25, 10]
    },
    onChange: onTableChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 508,
      columnNumber: 9
    }
  })));
};
exports.SpaceAssignedRolesTable = SpaceAssignedRolesTable;