"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _constants = require("../../../../constants");
var _app_context = require("../../../../app_context");
var _navigation = require("../../../../services/navigation");
var _components = require("../../../../components");
var _snapshot_search_bar = require("./snapshot_search_bar");
var _snapshot_state = require("../snapshot_details/tabs/snapshot_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/snapshot_list/components/snapshot_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SnapshotTable = props => {
  const {
    snapshots,
    repositories,
    reload,
    onSnapshotDeleted,
    listParams,
    setListParams,
    totalItemCount,
    isLoading,
    error
  } = props;
  const {
    i18n,
    uiMetricService,
    history
  } = (0, _app_context.useServices)();
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const columns = [{
    field: 'snapshot',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.snapshotColumnTitle', {
      defaultMessage: 'Snapshot'
    }),
    truncateText: false,
    sortable: true,
    render: (snapshotId, snapshot) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _shared_imports.reactRouterNavigate)(history, (0, _navigation.linkToSnapshot)(snapshot.repository, snapshotId), () => uiMetricService.trackUiMetric(_constants.UIM_SNAPSHOT_SHOW_DETAILS_CLICK)), {
      "data-test-subj": "snapshotLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }), snapshotId)
  }, {
    field: 'state',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.stateColumnTitle', {
      defaultMessage: 'State'
    }),
    'data-test-subj': 'snapshotState',
    truncateText: false,
    sortable: false,
    render: state => /*#__PURE__*/_react.default.createElement(_snapshot_state.SnapshotState, {
      state: state,
      displayTooltipIcon: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 34
      }
    })
  }, {
    field: 'repository',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.repositoryColumnTitle', {
      defaultMessage: 'Repository'
    }),
    truncateText: false,
    sortable: true,
    render: repositoryName => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _shared_imports.reactRouterNavigate)(history, (0, _navigation.linkToRepository)(repositoryName)), {
      "data-test-subj": "repositoryLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }), repositoryName)
  }, {
    field: 'indices',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.indicesColumnTitle', {
      defaultMessage: 'Indices'
    }),
    truncateText: true,
    sortable: true,
    width: '100px',
    render: indices => indices.length
  }, {
    field: 'shards.total',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.shardsColumnTitle', {
      defaultMessage: 'Shards'
    }),
    truncateText: true,
    sortable: true,
    width: '100px',
    render: totalShards => totalShards
  }, {
    field: 'shards.failed',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.failedShardsColumnTitle', {
      defaultMessage: 'Failed shards'
    }),
    truncateText: true,
    sortable: true,
    width: '100px',
    render: failedShards => failedShards
  }, {
    field: 'startTimeInMillis',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.startTimeColumnTitle', {
      defaultMessage: 'Date created'
    }),
    truncateText: false,
    sortable: true,
    render: startTimeInMillis => /*#__PURE__*/_react.default.createElement(_components.DataPlaceholder, {
      data: startTimeInMillis,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
      epochMs: startTimeInMillis,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }))
  }, {
    field: 'durationInMillis',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.durationColumnTitle', {
      defaultMessage: 'Duration'
    }),
    truncateText: true,
    sortable: true,
    width: '100px',
    render: (durationInMillis, {
      state
    }) => {
      if (state === _constants.SNAPSHOT_STATE.IN_PROGRESS) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 157,
            columnNumber: 18
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_components.DataPlaceholder, {
        data: durationInMillis,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.snapshotList.table.durationColumnValueLabel",
        defaultMessage: "{seconds}s",
        values: {
          seconds: Math.ceil(durationInMillis / 1000)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 13
        }
      }));
    }
  }, {
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      render: ({
        snapshot,
        repository,
        state
      }) => {
        const canRestore = state === _constants.SNAPSHOT_STATE.SUCCESS || state === _constants.SNAPSHOT_STATE.PARTIAL;
        const label = canRestore ? i18n.translate('xpack.snapshotRestore.snapshotList.table.actionRestoreTooltip', {
          defaultMessage: 'Restore'
        }) : state === _constants.SNAPSHOT_STATE.IN_PROGRESS ? i18n.translate('xpack.snapshotRestore.snapshotList.table.actionRestoreDisabledInProgressTooltip', {
          defaultMessage: `Can't restore in-progress snapshot`
        }) : i18n.translate('xpack.snapshotRestore.snapshotList.table.actionRestoreDisabledInvalidTooltip', {
          defaultMessage: `Can't restore invalid snapshot`
        });
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: label,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 196,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
          "aria-label": i18n.translate('xpack.snapshotRestore.snapshotList.table.actionRestoreAriaLabel', {
            defaultMessage: 'Store snapshot `{name}`',
            values: {
              name: snapshot
            }
          }),
          iconType: "importAction",
          color: "primary",
          "data-test-subj": "srsnapshotListRestoreActionButton"
        }, (0, _shared_imports.reactRouterNavigate)(history, (0, _navigation.linkToRestoreSnapshot)(repository, snapshot)), {
          isDisabled: !canRestore,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 197,
            columnNumber: 17
          }
        })));
      }
    }, {
      render: snapshotDetails => {
        const {
          snapshot,
          repository,
          managedRepository,
          isLastSuccessfulSnapshot
        } = snapshotDetails;
        return /*#__PURE__*/_react.default.createElement(_components.SnapshotDeleteProvider, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 220,
            columnNumber: 15
          }
        }, deleteSnapshotPrompt => {
          const isDeleteDisabled = Boolean(managedRepository && repository === managedRepository && isLastSuccessfulSnapshot);
          const label = isDeleteDisabled ? i18n.translate('xpack.snapshotRestore.snapshotList.table.deleteManagedRepositorySnapshotTooltip', {
            defaultMessage: 'You must store the last successful snapshot in a managed repository.'
          }) : i18n.translate('xpack.snapshotRestore.snapshotList.table.actionDeleteTooltip', {
            defaultMessage: 'Delete'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: label,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 240,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            "aria-label": i18n.translate('xpack.snapshotRestore.snapshotList.table.actionDeleteAriaLabel', {
              defaultMessage: `Delete snapshot ''{name}''`,
              values: {
                name: snapshot
              }
            }),
            iconType: "trash",
            color: "danger",
            "data-test-subj": "srsnapshotListDeleteActionButton",
            onClick: () => deleteSnapshotPrompt([{
              snapshot,
              repository
            }], onSnapshotDeleted),
            isDisabled: isDeleteDisabled,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 241,
              columnNumber: 23
            }
          }));
        });
      }
    }],
    width: '100px'
  }];
  const sorting = {
    sort: {
      field: listParams.sortField,
      direction: listParams.sortDirection
    }
  };
  const pagination = {
    pageIndex: listParams.pageIndex,
    pageSize: listParams.pageSize,
    totalItemCount,
    pageSizeOptions: [10, 20, 50]
  };
  const selection = {
    onSelectionChange: newSelectedItems => setSelectedItems(newSelectedItems),
    selectable: ({
      repository,
      managedRepository,
      isLastSuccessfulSnapshot
    }) => !(managedRepository && repository === managedRepository && isLastSuccessfulSnapshot),
    selectableMessage: selectable => {
      if (!selectable) {
        return i18n.translate('xpack.snapshotRestore.snapshotList.table.deleteManagedRepositorySnapshotDescription', {
          defaultMessage: 'You must retain the last successful snapshot in a managed repository.'
        });
      }
      return '';
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_snapshot_search_bar.SnapshotSearchBar, {
    listParams: listParams,
    setListParams: setListParams,
    reload: reload,
    selectedItems: selectedItems,
    onSnapshotDeleted: onSnapshotDeleted,
    repositories: repositories,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 7
    }
  }), error ? error : /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: snapshots,
    itemId: item => `${item === null || item === void 0 ? void 0 : item.uuid}-${item === null || item === void 0 ? void 0 : item.repository}`,
    columns: columns,
    sorting: sorting,
    onChange: criteria => {
      var _ref, _ref2;
      const {
        page: {
          index,
          size
        } = {},
        sort: {
          field,
          direction
        } = {}
      } = criteria;
      setListParams({
        ...listParams,
        sortField: (_ref = field) !== null && _ref !== void 0 ? _ref : listParams.sortField,
        sortDirection: (_ref2 = direction) !== null && _ref2 !== void 0 ? _ref2 : listParams.sortDirection,
        pageIndex: index !== null && index !== void 0 ? index : listParams.pageIndex,
        pageSize: size !== null && size !== void 0 ? size : listParams.pageSize
      });
    },
    loading: isLoading,
    selection: selection,
    pagination: pagination,
    rowProps: () => ({
      'data-test-subj': 'row'
    }),
    cellProps: () => ({
      'data-test-subj': 'cell'
    }),
    "data-test-subj": "snapshotTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 9
    }
  }));
};
exports.SnapshotTable = SnapshotTable;