"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSloRouteRepository = void 0;
var _fetch_health = require("./fetch_health");
var _get_slo_settings = require("./get_slo_settings");
var _create_slo = require("./create_slo");
var _inspect_slo = require("./inspect_slo");
var _update_slo = require("./update_slo");
var _delete_slo = require("./delete_slo");
var _enable_slo = require("./enable_slo");
var _get_slo = require("./get_slo");
var _delete_instances = require("./delete_instances");
var _disable_slo = require("./disable_slo");
var _fetch_historical_summary = require("./fetch_historical_summary");
var _find_slo = require("./find_slo");
var _find_definitions = require("./find_definitions");
var _find_groups = require("./find_groups");
var _get_diagnosis = require("./get_diagnosis");
var _get_groupings = require("./get_groupings");
var _get_preview_data = require("./get_preview_data");
var _get_slo_burn_rates = require("./get_slo_burn_rates");
var _get_suggestions = require("./get_suggestions");
var _put_slo_settings = require("./put_slo_settings");
var _reset_slo = require("./reset_slo");
var _get_slo_stats_overview = require("./get_slo_stats_overview");
var _bulk_delete = require("./bulk_delete");
var _purge_rollup_data = require("./purge_rollup_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSloRouteRepository = isServerless => {
  return {
    ..._fetch_health.fetchSloHealthRoute,
    ..._get_slo_settings.getSloSettingsRoute,
    ...(0, _put_slo_settings.putSloSettings)(isServerless),
    ..._create_slo.createSLORoute,
    ..._inspect_slo.inspectSLORoute,
    ..._delete_slo.deleteSLORoute,
    ..._delete_instances.deleteSloInstancesRoute,
    ..._purge_rollup_data.bulkPurgeRollupRoute,
    ..._disable_slo.disableSLORoute,
    ..._enable_slo.enableSLORoute,
    ..._fetch_historical_summary.fetchHistoricalSummary,
    ..._find_definitions.findSloDefinitionsRoute,
    ..._find_slo.findSLORoute,
    ..._get_slo.getSLORoute,
    ..._update_slo.updateSLORoute,
    ..._get_diagnosis.getDiagnosisRoute,
    ..._get_slo_burn_rates.getSloBurnRates,
    ..._get_preview_data.getPreviewData,
    ..._get_groupings.getSLOGroupingsRoute,
    ..._reset_slo.resetSLORoute,
    ..._find_groups.findSLOGroupsRoute,
    ..._get_suggestions.getSLOSuggestionsRoute,
    ..._get_slo_stats_overview.getSLOStatsOverview,
    ..._bulk_delete.bulkDeleteSLORoute,
    ..._bulk_delete.getBulkDeleteStatusRoute
  };
};
exports.getSloRouteRepository = getSloRouteRepository;