"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSLOGroupingsRoute = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _get_slo_groupings = require("../../services/get_slo_groupings");
var _slo_definition_client = require("../../services/slo_definition_client");
var _slo_settings = require("../../services/slo_settings");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSLOGroupingsRoute = exports.getSLOGroupingsRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /internal/observability/slos/{id}/_groupings',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_read']
    }
  },
  params: _sloSchema.getSLOGroupingsParamsSchema,
  handler: async ({
    request,
    logger,
    params,
    plugins,
    getScopedClients
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      scopedClusterClient,
      repository,
      soClient,
      spaceId
    } = await getScopedClients({
      request,
      logger
    });
    const settings = await (0, _slo_settings.getSloSettings)(soClient);
    const definitionClient = new _slo_definition_client.SloDefinitionClient(repository, scopedClusterClient.asCurrentUser, logger);
    const getSLOGroupings = new _get_slo_groupings.GetSLOGroupings(definitionClient, scopedClusterClient.asCurrentUser, settings, spaceId);
    return await getSLOGroupings.execute(params.path.id, params.query);
  }
});