"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.computeSLI = computeSLI;
exports.computeSLIForPreview = computeSLIForPreview;
var _number = require("../../utils/number");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_DATA = -1;
function computeSLI(good, total, totalSlicesInRange) {
  // We calculate the sli based on the totalSlices in the dateRange, as
  // 1 - error rate observed = 1 - (1 - SLI Observed) = SLI
  // a slice without data will be considered as a good slice
  if (totalSlicesInRange !== undefined && totalSlicesInRange > 0) {
    return (0, _number.toHighPrecision)(1 - (total - good) / totalSlicesInRange);
  }
  if (total === 0) {
    return NO_DATA;
  }
  return (0, _number.toHighPrecision)(good / total);
}
function computeSLIForPreview(good, total) {
  const sliValue = computeSLI(good, total);
  if (sliValue === NO_DATA) {
    return null;
  }
  return sliValue;
}