"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloList = SloList;
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _dedent = _interopRequireDefault(require("dedent"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _ebtTools = require("@kbn/ebt-tools");
var _use_fetch_slo_list = require("../../../hooks/use_fetch_slo_list");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_url_search_state = require("../hooks/use_url_search_state");
var _group_view = require("./grouped_slos/group_view");
var _toggle_slo_view = require("./toggle_slo_view");
var _ungrouped_view = require("./ungrouped_slos/ungrouped_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/slo_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloList() {
  var _sloList$total;
  const {
    observabilityAIAssistant
  } = (0, _use_kibana.useKibana)().services;
  const {
    state,
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const {
    view,
    page,
    perPage,
    kqlQuery,
    filters,
    tagsFilter,
    statusFilter,
    groupBy
  } = state;
  const {
    isLoading,
    isRefetching,
    isError,
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    tagsFilter,
    statusFilter,
    perPage,
    filters,
    page: page + 1,
    kqlQuery,
    sortBy: state.sort.by,
    sortDirection: state.sort.direction,
    lastRefresh: state.lastRefresh
  });
  const isDeletingSlo = Boolean((0, _reactQuery.useIsMutating)(['deleteSlo']));
  (0, _react.useEffect)(() => {
    if (!sloList || !observabilityAIAssistant) {
      return;
    }
    const slosByStatus = (0, _lodash.mapValues)((0, _lodash.groupBy)(sloList.results, result => result.summary.status), groupResults => groupResults.map(result => `- ${result.name}`).join('\n'));
    return observabilityAIAssistant.service.setScreenContext({
      screenDescription: (0, _dedent.default)(`The user is looking at a list of SLOs.

      ${sloList.total >= 1 ? `There are ${sloList.total} SLOs. Out of those, ${sloList.results.length} are visible.

          Violating SLOs:
          ${slosByStatus.VIOLATED}

          Degrading SLOs:
          ${slosByStatus.DEGRADING}

          Healthy SLOs:
          ${slosByStatus.HEALTHY}

          SLOs without data:
          ${slosByStatus.NO_DATA}

          ` : ''}
      `)
    });
  }, [sloList, observabilityAIAssistant]);
  (0, _ebtTools.usePageReady)({
    isReady: !isLoading && sloList !== undefined,
    isRefreshing: isLoading,
    customMetrics: {
      key1: 'slo_list_count',
      value1: (_sloList$total = sloList === null || sloList === void 0 ? void 0 : sloList.total) !== null && _sloList$total !== void 0 ? _sloList$total : 0
    },
    meta: {
      description: '[ttfmp_slos] The SLOs list has finished loading.'
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "sloList",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_toggle_slo_view.ToggleSLOView, {
    sloList: sloList,
    view: view,
    onChangeView: newView => onStateChange({
      view: newView
    }),
    onStateChange: onStateChange,
    state: state,
    loading: isLoading || isDeletingSlo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  })), groupBy === 'ungrouped' && /*#__PURE__*/_react.default.createElement(_ungrouped_view.UngroupedView, {
    sloList: sloList,
    loading: isLoading || isRefetching,
    error: isError,
    view: view,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }), groupBy !== 'ungrouped' && /*#__PURE__*/_react.default.createElement(_group_view.GroupView, {
    view: view,
    groupBy: groupBy,
    kqlQuery: kqlQuery,
    sort: state.sort.by,
    direction: state.sort.direction,
    filters: filters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }));
}