"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SliChartPanel = SliChartPanel;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _labels = require("../../../utils/slo/labels");
var _wide_chart = require("./wide_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/sli_chart_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SliChartPanel({
  data,
  isLoading,
  slo,
  hideMetadata = false,
  onBrushed
}) {
  const {
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const isSloFailed = slo.summary.status === 'DEGRADING' || slo.summary.status === 'VIOLATED';
  const hasNoData = slo.summary.status === 'NO_DATA';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "sliChartPanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.slo.sloDetails.sliHistoryChartPanel.title', {
    defaultMessage: 'Historical SLI'
  })))), !hideMetadata && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 15
    }
  }, _sloSchema.rollingTimeWindowTypeSchema.is(slo.timeWindow.type) ? _i18n.i18n.translate('xpack.slo.sloDetails.sliHistoryChartPanel.duration', {
    defaultMessage: 'Last {duration}',
    values: {
      duration: (0, _labels.toDurationLabel)(slo.timeWindow.duration)
    }
  }) : (0, _labels.toDurationAdverbLabel)(slo.timeWindow.duration)))), !hideMetadata && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l",
    alignItems: "flexStart",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleColor: isSloFailed ? 'danger' : 'success',
    title: hasNoData ? '-' : (0, _numeral.default)(slo.summary.sliValue).format(percentFormat),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.slo.sloDetails.sliHistoryChartPanel.current', {
      defaultMessage: 'Observed value'
    }),
    reverse: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: (0, _numeral.default)(slo.objective.target).format(percentFormat),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.slo.sloDetails.sliHistoryChartPanel.objective', {
      defaultMessage: 'Objective'
    }),
    reverse: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_wide_chart.WideChart, {
    slo: slo,
    chart: "line",
    id: _i18n.i18n.translate('xpack.slo.sloDetails.sliHistoryChartPanel.chartTitle', {
      defaultMessage: 'SLI value'
    }),
    state: isSloFailed ? 'error' : 'success',
    data: data,
    isLoading: isLoading,
    onBrushed: onBrushed,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }))));
}