"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorBudgetChart = ErrorBudgetChart;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _duration = require("../../../utils/slo/duration");
var _wide_chart = require("./wide_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/error_budget_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function formatTime(minutes) {
  if (minutes > 59) {
    const mins = minutes % 60;
    const hours = (minutes - mins) / 60;
    return _i18n.i18n.translate('xpack.slo.sloDetails.errorBudgetChartPanel.minuteHoursLabel', {
      defaultMessage: '{hours}h {mins}m',
      values: {
        hours: Math.trunc(hours),
        mins: Math.trunc(mins)
      }
    });
  }
  return _i18n.i18n.translate('xpack.slo.sloDetails.errorBudgetChartPanel.minuteLabel', {
    defaultMessage: '{minutes}m',
    values: {
      minutes
    }
  });
}
function ErrorBudgetChart({
  data,
  isLoading,
  slo,
  hideMetadata = false,
  onBrushed
}) {
  const {
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const isSloFailed = slo.summary.status === 'DEGRADING' || slo.summary.status === 'VIOLATED';
  let errorBudgetTimeRemainingFormatted;
  if (slo.budgetingMethod === 'timeslices' && slo.timeWindow.type === 'calendarAligned') {
    const totalSlices = (0, _duration.toMinutes)((0, _duration.toDuration)(slo.timeWindow.duration)) / (0, _duration.toMinutes)((0, _duration.toDuration)(slo.objective.timesliceWindow));
    const errorBudgetRemainingInMinute = slo.summary.errorBudget.remaining * (slo.summary.errorBudget.initial * totalSlices);
    errorBudgetTimeRemainingFormatted = formatTime(errorBudgetRemainingInMinute >= 0 ? errorBudgetRemainingInMinute : 0);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideMetadata && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l",
    alignItems: "flexStart",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleColor: isSloFailed ? 'danger' : 'success',
    title: (0, _numeral.default)(slo.summary.errorBudget.remaining).format(percentFormat),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.slo.sloDetails.errorBudgetChartPanel.remaining', {
      defaultMessage: 'Remaining'
    }),
    reverse: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  })), errorBudgetTimeRemainingFormatted ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleColor: isSloFailed ? 'danger' : 'success',
    title: errorBudgetTimeRemainingFormatted,
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.slo.sloDetails.errorBudgetChartPanel.remaining', {
      defaultMessage: 'Remaining'
    }),
    reverse: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 15
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_wide_chart.WideChart, {
    chart: "area",
    id: _i18n.i18n.translate('xpack.slo.sloDetails.errorBudgetChartPanel.chartTitle', {
      defaultMessage: 'Error budget remaining'
    }),
    state: isSloFailed ? 'error' : 'success',
    data: data,
    isLoading: isLoading,
    onBrushed: onBrushed,
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  })));
}