"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchActiveAlerts = useFetchActiveAlerts;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/rule-registry-plugin/common");
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var _common2 = require("@kbn/slo-schema/src/schema/common");
var _use_kibana = require("./use_kibana");
var _query_key_factory = require("./query_key_factory");
var _active_alerts = require("./active_alerts");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_ACTIVE_ALERTS_MAP = new _active_alerts.ActiveAlerts();
function useFetchActiveAlerts({
  sloIdsAndInstanceIds = [],
  shouldRefetch = false,
  rangeFrom = 'now-5m/m'
}) {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.activeAlert(sloIdsAndInstanceIds),
    queryFn: async ({
      signal
    }) => {
      try {
        const response = await http.post(`${_common.BASE_RAC_ALERTS_API_PATH}/find`, {
          body: JSON.stringify({
            rule_type_ids: _technical_rule_data_field_names.SLO_RULE_TYPE_IDS,
            consumers: [_technical_rule_data_field_names.AlertConsumers.SLO, _technical_rule_data_field_names.AlertConsumers.OBSERVABILITY, _technical_rule_data_field_names.AlertConsumers.ALERTS],
            size: 0,
            query: {
              bool: {
                filter: [{
                  range: {
                    '@timestamp': {
                      gte: rangeFrom
                    }
                  }
                }, {
                  term: {
                    'kibana.alert.status': 'active'
                  }
                }],
                should: sloIdsAndInstanceIds.map(([sloId, instanceId]) => ({
                  bool: {
                    filter: [{
                      term: {
                        'slo.id': sloId
                      }
                    }, ...(instanceId === _common2.ALL_VALUE ? [] : [{
                      term: {
                        'slo.instanceId': instanceId
                      }
                    }])]
                  }
                })),
                minimum_should_match: 1
              }
            },
            aggs: {
              perSloId: {
                multi_terms: {
                  size: 10000,
                  terms: [{
                    field: 'slo.id'
                  }, {
                    field: 'slo.instanceId'
                  }]
                }
              }
            }
          }),
          signal
        });
        const activeAlertsData = response.aggregations.perSloId.buckets.reduce((acc, bucket) => {
          var _bucket$doc_count;
          return {
            ...acc,
            [bucket.key_as_string]: (_bucket$doc_count = bucket.doc_count) !== null && _bucket$doc_count !== void 0 ? _bucket$doc_count : 0
          };
        }, {});
        return new _active_alerts.ActiveAlerts(activeAlertsData);
      } catch (error) {
        // ignore error
      }
    },
    refetchOnWindowFocus: false,
    refetchInterval: shouldRefetch ? _constants.SLO_LONG_REFETCH_INTERVAL : undefined,
    enabled: Boolean(sloIdsAndInstanceIds.length)
  });
  return {
    data: isInitialLoading ? EMPTY_ACTIVE_ALERTS_MAP : data !== null && data !== void 0 ? data : EMPTY_ACTIVE_ALERTS_MAP,
    isLoading: isInitialLoading || isLoading || isRefetching,
    isSuccess,
    isError
  };
}