"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildViolatedSummary = exports.buildTimeslicesObjective = exports.buildOccurrencesObjective = exports.buildNoDataSummary = exports.buildHealthySummary = exports.buildDegradingSummary = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildOccurrencesObjective = (params = {}) => {
  return {
    target: 0.99,
    ...params
  };
};
exports.buildOccurrencesObjective = buildOccurrencesObjective;
const buildTimeslicesObjective = (params = {}) => {
  return {
    target: 0.99,
    timesliceTarget: 0.95,
    timesliceWindow: '5m',
    ...params
  };
};
exports.buildTimeslicesObjective = buildTimeslicesObjective;
const buildHealthySummary = (params = {}) => {
  return {
    status: 'HEALTHY',
    sliValue: 0.99872,
    errorBudget: {
      initial: 0.02,
      consumed: 0.0642,
      remaining: 0.93623,
      isEstimated: false
    },
    fiveMinuteBurnRate: 0,
    oneHourBurnRate: 0,
    oneDayBurnRate: 0,
    ...params
  };
};
exports.buildHealthySummary = buildHealthySummary;
const buildViolatedSummary = (params = {}) => {
  return {
    status: 'VIOLATED',
    sliValue: 0.81232,
    errorBudget: {
      initial: 0.02,
      consumed: 1,
      remaining: -3.1234,
      isEstimated: false
    },
    fiveMinuteBurnRate: 0,
    oneHourBurnRate: 0,
    oneDayBurnRate: 0,
    ...params
  };
};
exports.buildViolatedSummary = buildViolatedSummary;
const buildNoDataSummary = (params = {}) => {
  return {
    status: 'NO_DATA',
    sliValue: -1,
    errorBudget: {
      initial: 0.02,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    fiveMinuteBurnRate: 0,
    oneHourBurnRate: 0,
    oneDayBurnRate: 0,
    ...params
  };
};
exports.buildNoDataSummary = buildNoDataSummary;
const buildDegradingSummary = (params = {}) => {
  return {
    status: 'DEGRADING',
    sliValue: 0.97982,
    errorBudget: {
      initial: 0.01,
      consumed: 0.8822,
      remaining: 0.1244,
      isEstimated: true
    },
    fiveMinuteBurnRate: 0,
    oneHourBurnRate: 0,
    oneDayBurnRate: 0,
    ...params
  };
};
exports.buildDegradingSummary = buildDegradingSummary;