"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloResetConfirmationModal = SloResetConfirmationModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_reset_slo = require("../../../hooks/use_reset_slo");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/reset_confirmation_modal/slo_reset_confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloResetConfirmationModal({
  slo,
  onCancel,
  onConfirm
}) {
  const {
    mutate: resetSlo
  } = (0, _use_reset_slo.useResetSlo)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    buttonColor: "danger",
    "data-test-subj": "sloResetConfirmationModal",
    title: _i18n.i18n.translate('xpack.slo.resetConfirmationModal.title', {
      defaultMessage: 'Reset {name}?',
      values: {
        name: slo.name
      }
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.slo.resetConfirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.slo.resetConfirmationModal.resetButtonLabel', {
      defaultMessage: 'Reset'
    }),
    onCancel: onCancel,
    onConfirm: () => {
      resetSlo({
        id: slo.id,
        name: slo.name
      });
      onConfirm();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.slo.resetConfirmationModal.descriptionText', {
    defaultMessage: 'Resetting this SLO will also regenerate the historical data.'
  }));
}