"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisPanel = LogRateAnalysisPanel;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _log_rate_analysis_type = require("@kbn/aiops-log-rate-analysis/log_rate_analysis_type");
var _public = require("@kbn/aiops-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public2 = require("@kbn/observability-plugin/public");
var _common = require("@kbn/observability-shared-plugin/common");
var _i18n = require("@kbn/i18n");
var _alert = require("../../../utils/alert");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _log_rate_analysis_query = require("./helpers/log_rate_analysis_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/alert_details/components/custom_panels/custom_kql/log_rate_analysis_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getDataTimeRange(timeRange, window) {
  const windowDurationInMs = window.longWindow.value * 60 * 60 * 1000;
  return {
    from: new Date(new Date(timeRange.gte).getTime() - windowDurationInMs),
    to: timeRange.lte ? new Date(timeRange.lte) : new Date()
  };
}
function LogRateAnalysisPanel({
  slo,
  alert,
  rule
}) {
  var _alert$fields$ALERT_R, _alert$fields$ALERT_R2;
  const services = (0, _use_kibana.useKibana)().services;
  const {
    dataViews: dataViewsService,
    observabilityAIAssistant
  } = services;
  const ObservabilityAIAssistantContextualInsight = observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.ObservabilityAIAssistantContextualInsight;
  const [dataView, setDataView] = (0, _react.useState)();
  const [esSearchQuery, setEsSearchQuery] = (0, _react.useState)();
  const [logRateAnalysisParams, setLogRateAnalysisParams] = (0, _react.useState)();
  const params = slo.indicator.params;
  const groupBy = slo.groupBy;
  const groupings = slo.groupings;
  const {
    index
  } = params;
  const {
    data: dataViews = []
  } = (0, _public2.useFetchDataViews)();
  (0, _react.useEffect)(() => {
    const getDataView = async () => {
      var _getDataViewByIndexPa;
      const getDataViewByIndexPattern = indexPattern => dataViews.find(dataView0 => dataView0.title === indexPattern);
      const dataViewId = (_getDataViewByIndexPa = getDataViewByIndexPattern(index)) === null || _getDataViewByIndexPa === void 0 ? void 0 : _getDataViewByIndexPa.id;
      if (dataViewId) {
        const sloDataView = await dataViewsService.get(dataViewId);
        setDataView(sloDataView);
        getQuery();
      }
    };
    const getQuery = () => {
      const esSearchRequest = (0, _log_rate_analysis_query.getESQueryForLogRateAnalysis)(params, groupBy, groupings);
      if (esSearchRequest) {
        setEsSearchQuery(esSearchRequest);
      }
    };
    getDataView();
  }, [index, dataViews, params, dataViewsService, groupBy, groupings]);

  // Identify `intervalFactor` to adjust time ranges based on alert settings.
  // The default time ranges for `initialAnalysisStart` are suitable for a `1m` lookback.
  // If an alert would have a `5m` lookback, this would result in a factor of `5`.
  // If an alert is just starting, the visible time range to look back might not cover the
  // long window yet, only then we'll take the short window to look back,
  // otherwise it will be the long window.
  const alertActionGroup = (0, _alert.getActionGroupFromReason)(alert.reason);
  const relatedWindow = ((_alert$fields$ALERT_R = (_alert$fields$ALERT_R2 = alert.fields[_ruleDataUtils.ALERT_RULE_PARAMETERS]) === null || _alert$fields$ALERT_R2 === void 0 ? void 0 : _alert$fields$ALERT_R2.windows) !== null && _alert$fields$ALERT_R !== void 0 ? _alert$fields$ALERT_R : []).find(window => window.actionGroup === alertActionGroup);
  const longWindowValue = relatedWindow === null || relatedWindow === void 0 ? void 0 : relatedWindow.longWindow.value;
  const longWindowUnit = relatedWindow === null || relatedWindow === void 0 ? void 0 : relatedWindow.longWindow.unit;
  const longWindowLookbackDuration = longWindowValue && longWindowUnit ? _moment.default.duration(longWindowValue, longWindowUnit) : _moment.default.duration(1, 'm');
  const longWindowLookbackDurationAsSeconds = longWindowLookbackDuration.asSeconds();
  const shortWindowValue = relatedWindow === null || relatedWindow === void 0 ? void 0 : relatedWindow.shortWindow.value;
  const shortWindowUnit = relatedWindow === null || relatedWindow === void 0 ? void 0 : relatedWindow.shortWindow.unit;
  const shortWindowLookbackDuration = shortWindowValue && shortWindowUnit ? _moment.default.duration(shortWindowValue, shortWindowUnit) : _moment.default.duration(1, 'm');
  const shortWindowLookbackDurationAsSeconds = shortWindowLookbackDuration.asSeconds();

  // @ts-ignore
  const dataTimeRange = getDataTimeRange(alert.fields[_ruleDataUtils.ALERT_TIME_RANGE], relatedWindow);
  const timeRange = {
    min: (0, _moment.default)(dataTimeRange.from),
    max: (0, _moment.default)(dataTimeRange.to)
  };
  const alertStart = (0, _moment.default)(alert.start);
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END] ? (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]) : undefined;
  const chartStartToAlertStart = (alert.start - dataTimeRange.from.getTime()) / 1000;

  // Here we check if the available time range before the alert start is long enough
  // to consider the long window lookback. We consider 3x the long window to be good enough
  // to cover both the look back within the deviation and the baseline time range.
  // If the available time range is shorter we fall back to the short window.
  const lookbackDurationAsSeconds = longWindowLookbackDurationAsSeconds * 3 < chartStartToAlertStart ? longWindowLookbackDurationAsSeconds : shortWindowLookbackDurationAsSeconds;
  const intervalFactor = Math.max(1, lookbackDurationAsSeconds / 60);
  const logRateAnalysisTitle = _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetails.logRateAnalysisTitle', {
    defaultMessage: 'Possible causes and remediations'
  });
  function getDeviationMax() {
    if (alertEnd) {
      return alertEnd.clone().subtract(1 * intervalFactor, 'minutes').valueOf();
    } else if (alertStart.clone().add(10 * intervalFactor, 'minutes').isAfter((0, _moment.default)(new Date()))) {
      return (0, _moment.default)(new Date()).valueOf();
    } else {
      return alertStart.clone().add(10 * intervalFactor, 'minutes').valueOf();
    }
  }
  const initialAnalysisStart = {
    baselineMin: alertStart.clone().subtract(13 * intervalFactor, 'minutes').valueOf(),
    baselineMax: alertStart.clone().subtract(2 * intervalFactor, 'minutes').valueOf(),
    deviationMin: alertStart.clone().subtract(1 * intervalFactor, 'minutes').valueOf(),
    deviationMax: getDeviationMax()
  };
  const onAnalysisCompleted = analysisResults => {
    var _analysisResults$sign;
    const significantFieldValues = (0, _lodash.orderBy)(analysisResults === null || analysisResults === void 0 ? void 0 : (_analysisResults$sign = analysisResults.significantItems) === null || _analysisResults$sign === void 0 ? void 0 : _analysisResults$sign.map(item => ({
      field: item.fieldName,
      value: item.fieldValue,
      docCount: item.doc_count,
      pValue: item.pValue
    })), ['pValue', 'docCount'], ['asc', 'asc']).slice(0, 50);
    const logRateAnalysisType = analysisResults === null || analysisResults === void 0 ? void 0 : analysisResults.analysisType;
    setLogRateAnalysisParams(significantFieldValues && logRateAnalysisType ? {
      logRateAnalysisType,
      significantFieldValues
    } : undefined);
  };
  const messages = (0, _react.useMemo)(() => {
    var _logRateAnalysisParam;
    const hasLogRateAnalysisParams = logRateAnalysisParams && ((_logRateAnalysisParam = logRateAnalysisParams.significantFieldValues) === null || _logRateAnalysisParam === void 0 ? void 0 : _logRateAnalysisParam.length) > 0;
    if (!hasLogRateAnalysisParams) {
      return undefined;
    }
    const {
      logRateAnalysisType
    } = logRateAnalysisParams;
    const header = 'Field name,Field value,Doc count,p-value';
    const rows = logRateAnalysisParams.significantFieldValues.map(item => Object.values(item).join(',')).join('\n');
    const content = `You are an observability expert using Elastic Observability Suite on call being consulted about a log threshold alert that got triggered by a ${logRateAnalysisType} in log messages. Your job is to take immediate action and proceed with both urgency and precision.
      "Log Rate Analysis" is an AIOps feature that uses advanced statistical methods to identify reasons for increases and decreases in log rates. It makes it easy to find and investigate causes of unusual spikes or dips by using the analysis workflow view.
      You are using "Log Rate Analysis" and ran the statistical analysis on the log messages which occured during the alert.
      You received the following analysis results from "Log Rate Analysis" which list statistically significant co-occuring field/value combinations sorted from most significant (lower p-values) to least significant (higher p-values) that ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'contribute to the log rate spike' : 'are less or not present in the log rate dip'}:

      ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'The median log rate in the selected deviation time range is higher than the baseline. Therefore, the results shows statistically significant items within the deviation time range that are contributors to the spike. The "doc count" column refers to the amount of documents in the deviation time range.' : 'The median log rate in the selected deviation time range is lower than the baseline. Therefore, the analysis results table shows statistically significant items within the baseline time range that are less in number or missing within the deviation time range. The "doc count" column refers to the amount of documents in the baseline time range.'}

      ${header}
      ${rows}

      Based on the above analysis results and your observability expert knowledge, output the following:
      Analyse the type of these logs and explain their usual purpose (1 paragraph).
      ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'Based on the type of these logs do a root cause analysis on why the field and value combinations from the analysis results are causing this log rate spike (2 parapraphs)' : 'Based on the type of these logs explain why the statistically significant field and value combinations are less in number or missing from the log rate dip with concrete examples based on the analysis results data which contains items that are present in the baseline time range and are missing or less in number in the deviation time range (2 paragraphs)'}.
      ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'Recommend concrete remediations to resolve the root cause (3 bullet points).' : ''}

      Do not mention individual p-values from the analysis results.
      Do not repeat the full list of field names and field values back to the user.
      Do not guess, just say what you are sure of. Do not repeat the given instructions in your output.`;
    return observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.getContextualInsightMessages({
      message: 'Can you identify possible causes and remediations for these log rate analysis results',
      instructions: content
    });
  }, [logRateAnalysisParams, observabilityAIAssistant]);
  if (!dataView || !esSearchQuery) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "logRateAnalysisBurnRateAlertDetails",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.burnRate.alertDetails.logRateAnalysis.sectionTitle",
    defaultMessage: "Log Rate Analysis",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.LogRateAnalysisContent, {
    dataView: dataView,
    esSearchQuery: esSearchQuery,
    timeRange: timeRange,
    initialAnalysisStart: initialAnalysisStart,
    barColorOverride: (0, _common.colorTransformer)('color0'),
    barHighlightColorOverride: (0, _common.colorTransformer)('color1'),
    onAnalysisCompleted: onAnalysisCompleted,
    appContextValue: {
      embeddingOrigin: 'observability_slo_burn_rate_alert_details',
      ...(0, _lodash.pick)(services, ['analytics', 'application', 'data', 'executionContext', 'charts', 'fieldFormats', 'http', 'notifications', 'share', 'storage', 'uiSettings', 'unifiedSearch', 'theme', 'userProfile', 'lens', 'i18n'])
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 7
    }
  }, ObservabilityAIAssistantContextualInsight && messages ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantContextualInsight, {
    title: logRateAnalysisTitle,
    messages: messages,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 13
    }
  })) : null));
}