"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _context = require("../context");
var _draft_mode_callout = require("../common/draft_mode_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/share/public/components/export_integrations/export_integrations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExportMenu = ({
  shareContext
}) => {
  return /*#__PURE__*/_react.default.createElement(_context.ShareProvider, {
    shareContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement((0, _i18nReact.injectI18n)(ExportMenuPopover))));
};
exports.ExportMenu = ExportMenu;
function LayoutOptionsSwitch({
  usePrintLayout,
  printLayoutChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.exportFlyoutContent.optimizeForPrinting.label",
      defaultMessage: "Print format",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 17
      }
    }))),
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.exportFlyoutContent.optimizeForPrinting.helpText",
      defaultMessage: "Uses multiple pages, showing at most 2 visualizations per page ",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 15
      }
    })),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 15
      }
    }, usePrintLayout ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.exportFlyoutContent.optimizeForPrinting.selection.on",
      defaultMessage: "On",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 19
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.exportFlyoutContent.optimizeForPrinting.selection.off",
      defaultMessage: "Off",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 19
      }
    })),
    checked: usePrintLayout,
    onChange: printLayoutChange,
    "data-test-subj": "usePrintLayout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }))));
}
function ManagedFlyout({
  exportIntegration,
  intl,
  isDirty,
  onCloseFlyout,
  publicAPIEnabled,
  shareObjectTypeMeta,
  shareObjectType,
  shareObjectTypeAlias,
  onSave,
  isSaving
}) {
  var _shareObjectTypeMeta$, _shareObjectTypeMeta$2, _exportIntegration$co;
  const [usePrintLayout, setPrintLayout] = (0, _react.useState)(false);
  const [isCreatingExport, setIsCreatingExport] = (0, _react.useState)(false);
  const getReport = (0, _react.useCallback)(async () => {
    try {
      setIsCreatingExport(true);
      await exportIntegration.config.generateAssetExport({
        intl,
        optimizedForPrinting: usePrintLayout
      });
    } finally {
      setIsCreatingExport(false);
      onCloseFlyout();
    }
  }, [exportIntegration.config, intl, onCloseFlyout, usePrintLayout]);
  const draftModeCallout = (_shareObjectTypeMeta$ = shareObjectTypeMeta.config) === null || _shareObjectTypeMeta$ === void 0 ? void 0 : (_shareObjectTypeMeta$2 = _shareObjectTypeMeta$[exportIntegration.id]) === null || _shareObjectTypeMeta$2 === void 0 ? void 0 : _shareObjectTypeMeta$2.draftModeCallOut;
  // TODO Remove node override logic https://github.com/elastic/kibana/issues/238877
  const isValidCalloutOverride = /*#__PURE__*/_react.default.isValidElement(draftModeCallout);
  const draftModeCalloutContent = isValidCalloutOverride ?
  // Retro-compatible case
  {
    node: draftModeCallout
  } : typeof draftModeCallout === 'object' ?
  // Custom content callout
  draftModeCallout :
  // Default content callout
  {};
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.export.flyoutTitle",
    defaultMessage: "Export {objectType} as {type}",
    values: {
      objectType: shareObjectTypeAlias !== null && shareObjectTypeAlias !== void 0 ? shareObjectTypeAlias : shareObjectType.toLocaleLowerCase(),
      type: exportIntegration.config.label
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }, exportIntegration.config.renderLayoutOptionSwitch && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(LayoutOptionsSwitch, {
    usePrintLayout: usePrintLayout,
    printLayoutChange: evt => setPrintLayout(evt.target.checked),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }, (exportIntegration === null || exportIntegration === void 0 ? void 0 : exportIntegration.config.copyAssetURIConfig) && publicAPIEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 23
      }
    }, exportIntegration.config.copyAssetURIConfig.headingText)),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 23
    }
  }, exportIntegration.config.copyAssetURIConfig.helpText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "data-test-subj": "exportAssetValue",
    css: {
      overflowWrap: 'break-word'
    },
    overflowHeight: 360,
    language: exportIntegration.config.copyAssetURIConfig.contentType,
    isCopyable: true,
    copyAriaLabel: _i18n.i18n.translate('share.export.copyPostURLAriaLabel', {
      defaultMessage: 'Copy export asset value'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 23
    }
  }, exportIntegration.config.copyAssetURIConfig.generateAssetURIValue({
    intl,
    optimizedForPrinting: usePrintLayout
  }))))))), /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  }, exportIntegration.config.generateAssetComponent), /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  }, publicAPIEnabled && isDirty && draftModeCallout && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_draft_mode_callout.DraftModeCallout, (0, _extends2.default)({}, draftModeCalloutContent, onSave && {
    saveButtonProps: {
      onSave,
      isSaving
    }
  }, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "exportFlyoutCloseButton",
    onClick: onCloseFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.export.closeFlyoutButtonLabel",
    defaultMessage: "Close",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: getReport,
    "data-test-subj": "generateReportButton",
    isLoading: isCreatingExport,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 13
    }
  }, (_exportIntegration$co = exportIntegration.config.generateExportButtonLabel) !== null && _exportIntegration$co !== void 0 ? _exportIntegration$co : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.export.generateButtonLabel",
    defaultMessage: "Export {type}",
    values: {
      type: exportIntegration.config.label
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 17
    }
  }))))));
}
function ExportMenuPopover({
  intl
}) {
  const {
    onSave,
    isSaving
  } = (0, _context.useShareContext)();
  const {
    onClose,
    anchorElement,
    shareMenuItems: exportIntegrations,
    isDirty,
    publicAPIEnabled,
    objectType,
    objectTypeAlias,
    objectTypeMeta
  } = (0, _context.useShareTypeContext)('integration', 'export');
  const {
    shareMenuItems: exportDerivatives
  } = (0, _context.useShareTypeContext)('integration', 'exportDerivatives');
  const availableExportDerivatives = (0, _react.useMemo)(() => exportDerivatives.filter(exportDerivative => exportDerivative.config.shouldRender({
    availableExportItems: exportIntegrations
  })), [exportDerivatives, exportIntegrations]);
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const selectionOptions = (0, _react.useRef)({
    export: exportIntegrations,
    exportDerivatives
  });
  const [selectedMenuItemMeta, setSelectedMenuItemMeta] = (0, _react.useState)();
  const selectedMenuItem = (0, _react.useMemo)(() => {
    let result = null;
    if (!selectedMenuItemMeta) {
      return result;
    }
    selectionOptions.current[selectedMenuItemMeta.group].forEach(item => {
      if (item.id === selectedMenuItemMeta.id) {
        result = item;
      }
    });
    return result;
  }, [selectedMenuItemMeta]);
  const openFlyout = (0, _react.useCallback)(menuItem => {
    setSelectedMenuItemMeta({
      id: menuItem.id,
      group: menuItem.groupId
    });
    setIsFlyoutVisible(true);
  }, []);
  const exportIntegrationInteractionHandler = (0, _react.useCallback)(async menuItem => {
    if (!menuItem.config.copyAssetURIConfig && !menuItem.config.generateAssetComponent && menuItem.config.generateAssetExport) {
      await menuItem.config.generateAssetExport({
        intl,
        optimizedForPrinting: false
      }).finally(() => {
        onClose();
      });
    } else {
      openFlyout(menuItem);
    }
  }, [intl, onClose, openFlyout]);
  const flyoutRef = (0, _react.useRef)(null);
  const canSkipDisplayingPopover = (0, _react.useMemo)(() => {
    // when there is only one export share menu item, and no export derivatives registered,
    // we'd like to skip displaying the popover
    return exportIntegrations.length === 1 && !exportDerivatives.length;
  }, [exportIntegrations, exportDerivatives]);
  const flyoutOnCloseHandler = (0, _react.useCallback)(() => {
    setIsFlyoutVisible(false);
    if (canSkipDisplayingPopover) {
      onClose();
    }
  }, [onClose, canSkipDisplayingPopover]);
  (0, _react.useEffect)(() => {
    if (canSkipDisplayingPopover && !selectedMenuItemMeta) {
      exportIntegrationInteractionHandler(exportIntegrations[0]);
    }
  }, [exportIntegrationInteractionHandler, exportIntegrations, onClose, selectedMenuItemMeta, canSkipDisplayingPopover]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    isOpen: !isFlyoutVisible && !canSkipDisplayingPopover,
    button: anchorElement,
    closePopover: onClose,
    panelPaddingSize: "s",
    panelProps: {
      'data-test-subj': 'exportPopoverPanel'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 9
    }
  }, exportIntegrations.map(menuItem => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: selectedMenuItem === null || selectedMenuItem === void 0 ? void 0 : selectedMenuItem.config.toolTipContent,
    key: menuItem.id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 394,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    iconType: menuItem.config.icon,
    key: menuItem.id,
    label: menuItem.config.label,
    "data-test-subj": `exportMenuItem-${menuItem.config.label}`,
    isDisabled: menuItem.config.disabled,
    onClick: exportIntegrationInteractionHandler.bind(null, menuItem),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 15
    }
  })))), Boolean(availableExportDerivatives.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 13
    }
  }, availableExportDerivatives.map(exportDerivative => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: exportDerivative.id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 416,
        columnNumber: 19
      }
    }, exportDerivative.config.label({
      openFlyout: openFlyout.bind(null, exportDerivative)
    }));
  })))), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, (0, _extends2.default)({
    "data-test-subj": "exportItemDetailsFlyout",
    size: "s",
    onClose: flyoutOnCloseHandler,
    css: () => ({
      ['--euiFixedHeadersOffset']: 0,
      isolation: 'isolate' // ensures that tooltips within this flyout render as should
    }),
    ownFocus: true,
    maskProps: {
      headerZindexLocation: 'above'
    },
    ref: flyoutRef
  }, (selectedMenuItem === null || selectedMenuItem === void 0 ? void 0 : selectedMenuItem.groupId) === 'exportDerivatives' ? selectedMenuItem.config.flyoutSizing || {} : {}, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_react2.Global
  // @ts-expect-error -- we pass a z-index specifying important so we override the default z-index, so solve a known bug,
  // where when `headerZindexLocation` is set to `above`, the popover panel z-index is not high enough
  , {
    styles: {
      '.euiPopover__panel[data-popover-open="true"]': {
        zIndex: '7000 !important'
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 11
    }
  }), selectedMenuItemMeta.group === 'export' ? /*#__PURE__*/_react.default.createElement(ManagedFlyout, {
    exportIntegration: selectedMenuItem,
    shareObjectType: objectType,
    shareObjectTypeAlias: objectTypeAlias,
    shareObjectTypeMeta: objectTypeMeta,
    isDirty: isDirty,
    publicAPIEnabled: publicAPIEnabled,
    intl: intl,
    onCloseFlyout: flyoutOnCloseHandler,
    onSave: onSave,
    isSaving: isSaving,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 13
    }
  }) : selectedMenuItem === null || selectedMenuItem === void 0 ? void 0 : selectedMenuItem.config.flyoutContent({
    flyoutRef,
    closeFlyout: flyoutOnCloseHandler
  })));
}