"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraftModeCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/share/public/components/common/draft_mode_callout/draft_mode_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const defaultCalloutMessage = _i18n.i18n.translate('share.draftModeCallout.message', {
  defaultMessage: 'This link might not be permanent. Save your changes to ensure it works as expected.'
});
const saveButtonText = _i18n.i18n.translate('share.draftModeCallout.saveButtonText', {
  defaultMessage: 'Save changes'
});

/**
 * A warning callout to indicate the user has unsaved changes.
 */
const DraftModeCallout = ({
  node,
  message = defaultCalloutMessage,
  ['data-test-subj']: dataTestSubj = 'unsavedChangesDraftModeCallOut',
  saveButtonProps
}) => {
  var _saveButtonProps$labe;
  return node ? node : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    "data-test-subj": dataTestSubj,
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('share.draftModeCallout.title', {
      defaultMessage: 'You have unsaved changes'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "p",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, message), saveButtonProps && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    fill: true,
    size: "s",
    "data-test-subj": saveButtonProps['data-test-subj'],
    onClick: saveButtonProps.onSave,
    isLoading: saveButtonProps.isSaving,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, (_saveButtonProps$labe = saveButtonProps.label) !== null && _saveButtonProps$labe !== void 0 ? _saveButtonProps$labe : saveButtonText));
};
exports.DraftModeCallout = DraftModeCallout;