"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = (tty, show) => {
  const {
    euiTheme
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      size,
      font,
      colors,
      border
    } = euiTheme;
    const container = {
      position: 'absolute',
      top: 0,
      opacity: show ? 1 : 0,
      transition: 'opacity .2s',
      pointerEvents: show ? 'auto' : 'none',
      width: '100%',
      height: '100%',
      overflow: 'hidden',
      zIndex: 10,
      '.euiRangeTick,.euiRangeLevel': {
        transition: 'left 500ms'
      }
    };
    const header = {
      visibility: show ? 'visible' : 'hidden',
      backgroundColor: `${euiTheme.components.forms.backgroundDisabled}`,
      padding: `${size.m} ${size.base}`
    };
    const windowBoundsColor = (0, _eui.transparentize)(colors.ghost, 0.6); // TODO: Borealis migration - replace transparentize with color token, get rid of ghost color

    const terminal = {
      minHeight: '100%',
      '.xterm': (0, _react2.css)`
        display: inline-block;
      `,
      '.xterm-screen': (0, _react2.css)`
        overflow-y: visible;
        border: ${border.width.thin} dotted ${windowBoundsColor};
        border-top: 0;
        border-left: 0;
        box-sizing: content-box;
      `
    };
    if (tty !== null && tty !== void 0 && tty.rows) {
      terminal['.xterm-screen:after'] = (0, _react2.css)`
        position: absolute;
        right: ${size.s};
        top: ${size.s};
        content: '${tty === null || tty === void 0 ? void 0 : tty.columns}x${tty === null || tty === void 0 ? void 0 : tty.rows}';
        color: ${windowBoundsColor};
        font-family: ${font.familyCode};
        font-size: ${size.m};
      `;
    }
    const scrollPane = {
      position: 'relative',
      transform: `translateY(${show ? 0 : '100%'})`,
      transition: 'transform .2s ease-in-out',
      width: '100%',
      height: 'calc(100% - 112px)',
      overflow: 'auto',
      backgroundColor: colors.ink
    };
    return {
      container,
      header,
      terminal,
      scrollPane
    };
  }, [euiTheme, show, tty === null || tty === void 0 ? void 0 : tty.rows, tty === null || tty === void 0 ? void 0 : tty.columns]);
  return cached;
};
exports.useStyles = useStyles;