"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = ({
  hasSearchResults
}) => {
  const {
    euiTheme
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const pagination = {
      position: 'absolute',
      top: euiTheme.size.s,
      right: euiTheme.size.xxl,
      'button[data-test-subj="pagination-button-last"]': {
        display: 'none'
      },
      'button[data-test-subj="pagination-button-first"]': {
        display: 'none'
      }
    };
    const noResults = {
      position: 'absolute',
      color: euiTheme.colors.subduedText,
      top: euiTheme.size.m,
      right: euiTheme.size.xxl
    };
    const searchBar = {
      position: 'relative',
      backgroundColor: euiTheme.components.forms.background,
      input: {
        paddingRight: hasSearchResults ? '200px' : euiTheme.size.xxl
      }
    };
    return {
      pagination,
      searchBar,
      noResults
    };
  }, [euiTheme, hasSearchResults]);
  return cached;
};
exports.useStyles = useStyles;