"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSessionViewProcessEvents = exports.useFetchSessionViewAlerts = exports.useFetchGetTotalIOBytes = exports.useFetchAlertStatus = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isSessionEventAction = action => {
  if (!action) {
    return false;
  }
  return [_constants.EVENT_ACTION_FORK, _constants.EVENT_ACTION_EXEC, _constants.EVENT_ACTION_EXECUTED, _constants.EVENT_ACTION_END].includes(action);
};
const useFetchSessionViewProcessEvents = (index, sessionEntityId, sessionStartTime, jumpToCursor) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const [currentJumpToCursor, setCurrentJumpToCursor] = (0, _react.useState)('');
  const cachingKeys = (0, _react.useMemo)(() => [_constants.QUERY_KEY_PROCESS_EVENTS, index, sessionEntityId, jumpToCursor], [index, sessionEntityId, jumpToCursor]);
  const query = (0, _reactQuery.useInfiniteQuery)(cachingKeys, async ({
    pageParam = {}
  }) => {
    var _res$events$map, _res$events;
    let {
      cursor
    } = pageParam;
    const {
      forward
    } = pageParam;
    if (!cursor && jumpToCursor) {
      cursor = jumpToCursor;
    }
    const res = await http.get(_constants.PROCESS_EVENTS_ROUTE, {
      version: _constants.CURRENT_API_VERSION,
      query: {
        index,
        sessionEntityId,
        sessionStartTime,
        cursor,
        forward
      }
    });
    const events = (_res$events$map = (_res$events = res.events) === null || _res$events === void 0 ? void 0 : _res$events.map(event => event._source)) !== null && _res$events$map !== void 0 ? _res$events$map : [];
    return {
      events,
      cursor,
      total: res.total
    };
  }, {
    getNextPageParam: (lastPage, pages) => {
      const isRefetch = pages.length === 1 && jumpToCursor;
      if (isRefetch || lastPage.events.length >= _constants.PROCESS_EVENTS_PER_PAGE) {
        var _filtered;
        const filtered = lastPage.events.filter(event => {
          var _event$event;
          const action = (_event$event = event.event) === null || _event$event === void 0 ? void 0 : _event$event.action;
          return isSessionEventAction(action);
        });
        const cursor = filtered === null || filtered === void 0 ? void 0 : (_filtered = filtered[filtered.length - 1]) === null || _filtered === void 0 ? void 0 : _filtered['@timestamp'];
        if (cursor) {
          return {
            cursor,
            forward: true
          };
        }
      }
    },
    getPreviousPageParam: (firstPage, pages) => {
      const filtered = firstPage.events.filter(event => {
        var _event$event2;
        const action = (_event$event2 = event.event) === null || _event$event2 === void 0 ? void 0 : _event$event2.action;
        return isSessionEventAction(action);
      });
      const atBeginning = pages.length > 1 && filtered.length < _constants.PROCESS_EVENTS_PER_PAGE;
      if (jumpToCursor && !atBeginning) {
        var _filtered$;
        // it's possible the first page returned no events
        // fallback to using jumpToCursor if there are no "forward" events.
        const cursor = ((_filtered$ = filtered[0]) === null || _filtered$ === void 0 ? void 0 : _filtered$['@timestamp']) || jumpToCursor;
        return {
          cursor,
          forward: false
        };
      }
    },
    refetchOnWindowFocus: false,
    refetchOnMount: false,
    refetchOnReconnect: false
  });
  (0, _react.useEffect)(() => {
    var _query$data;
    if (jumpToCursor && ((_query$data = query.data) === null || _query$data === void 0 ? void 0 : _query$data.pages.length) === 1 && jumpToCursor !== currentJumpToCursor) {
      query.fetchPreviousPage({
        cancelRefetch: true
      });
      setCurrentJumpToCursor(jumpToCursor);
    }
  }, [jumpToCursor, query, currentJumpToCursor]);
  return query;
};
exports.useFetchSessionViewProcessEvents = useFetchSessionViewProcessEvents;
const useFetchSessionViewAlerts = (sessionEntityId, sessionStartTime, investigatedAlertId) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const cachingKeys = [_constants.QUERY_KEY_ALERTS, sessionEntityId, investigatedAlertId];
  const query = (0, _reactQuery.useInfiniteQuery)(cachingKeys, async ({
    pageParam = {}
  }) => {
    var _res$events$map2, _res$events2;
    const {
      cursor
    } = pageParam;
    const res = await http.get(_constants.ALERTS_ROUTE, {
      version: _constants.CURRENT_API_VERSION,
      query: {
        sessionEntityId,
        sessionStartTime,
        investigatedAlertId,
        cursor
      }
    });
    const events = (_res$events$map2 = (_res$events2 = res.events) === null || _res$events2 === void 0 ? void 0 : _res$events2.map(event => event._source)) !== null && _res$events$map2 !== void 0 ? _res$events$map2 : [];
    return {
      events,
      cursor,
      total: res.total
    };
  }, {
    getNextPageParam: lastPage => {
      if (lastPage.events.length >= _constants.ALERTS_PER_PAGE) {
        return {
          cursor: lastPage.events[lastPage.events.length - 1]['@timestamp']
        };
      }
    },
    refetchOnWindowFocus: false,
    refetchOnMount: false,
    refetchOnReconnect: false
  });
  return query;
};
exports.useFetchSessionViewAlerts = useFetchSessionViewAlerts;
const useFetchAlertStatus = (updatedAlertsStatus, alertUuid) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const cachingKeys = [_constants.QUERY_KEY_ALERTS, alertUuid];
  const query = (0, _reactQuery.useQuery)(cachingKeys, async () => {
    var _res$events$map3, _res$events3, _events$0$kibana$aler, _events$, _events$$kibana, _events$$kibana$alert, _events$0$process$ent, _events$2, _events$2$process;
    if (!alertUuid) {
      return updatedAlertsStatus;
    }
    const res = await http.get(_constants.ALERT_STATUS_ROUTE, {
      version: _constants.CURRENT_API_VERSION,
      query: {
        alertUuid
      }
    });

    // TODO: add error handling
    const events = (_res$events$map3 = (_res$events3 = res.events) === null || _res$events3 === void 0 ? void 0 : _res$events3.map(event => event._source)) !== null && _res$events$map3 !== void 0 ? _res$events$map3 : [];
    return {
      ...updatedAlertsStatus,
      [alertUuid]: {
        status: (_events$0$kibana$aler = (_events$ = events[0]) === null || _events$ === void 0 ? void 0 : (_events$$kibana = _events$.kibana) === null || _events$$kibana === void 0 ? void 0 : (_events$$kibana$alert = _events$$kibana.alert) === null || _events$$kibana$alert === void 0 ? void 0 : _events$$kibana$alert.workflow_status) !== null && _events$0$kibana$aler !== void 0 ? _events$0$kibana$aler : '',
        processEntityId: (_events$0$process$ent = (_events$2 = events[0]) === null || _events$2 === void 0 ? void 0 : (_events$2$process = _events$2.process) === null || _events$2$process === void 0 ? void 0 : _events$2$process.entity_id) !== null && _events$0$process$ent !== void 0 ? _events$0$process$ent : ''
      }
    };
  }, {
    refetchOnWindowFocus: false,
    refetchOnMount: false,
    refetchOnReconnect: false,
    cacheTime: 0
  });
  return query;
};
exports.useFetchAlertStatus = useFetchAlertStatus;
const useFetchGetTotalIOBytes = (index, sessionEntityId, sessionStartTime) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const cachingKeys = [_constants.QUERY_KEY_GET_TOTAL_IO_BYTES, index, sessionEntityId];
  const query = (0, _reactQuery.useQuery)(cachingKeys, async () => {
    return http.get(_constants.GET_TOTAL_IO_BYTES_ROUTE, {
      version: _constants.CURRENT_API_VERSION,
      query: {
        index,
        sessionEntityId,
        sessionStartTime
      }
    });
  }, {
    refetchOnWindowFocus: false,
    refetchOnMount: false,
    refetchOnReconnect: false,
    cacheTime: 0
  });
  return query;
};
exports.useFetchGetTotalIOBytes = useFetchGetTotalIOBytes;