"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelMetadataTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _detail_panel_accordion = require("../detail_panel_accordion");
var _detail_panel_copy = require("../detail_panel_copy");
var _detail_panel_list_item = require("../detail_panel_list_item");
var _styles = require("./styles");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/detail_panel_metadata_tab/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Host Panel of  session view detail panel.
 */
const DetailPanelMetadataTab = ({
  processHost,
  processContainer,
  processOrchestrator,
  processCloud
}) => {
  const stylesChild = (0, _styles.useStyles)();
  const hostData = (0, _react.useMemo)(() => (0, _helpers.getHostData)(processHost), [processHost]);
  const containerData = (0, _react.useMemo)(() => (0, _helpers.getContainerData)(processContainer), [processContainer]);
  const orchestratorData = (0, _react.useMemo)(() => (0, _helpers.getOrchestratorData)(processOrchestrator), [processOrchestrator]);
  const cloudData = (0, _react.useMemo)(() => (0, _helpers.getCloudData)(processCloud), [processCloud]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    id: "metadataHost",
    title: _i18n.i18n.translate('xpack.sessionView.metadataDetailsTab.metadataHost', {
      defaultMessage: 'Host'
    }),
    initialIsOpen: true,
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 20
        }
      }, "id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.id: "${hostData.id}"`,
        tooltipContent: hostData.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 15
        }
      }, hostData.id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 20
        }
      }, "hostname"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.hostname: "${hostData.hostname}"`,
        tooltipContent: hostData.hostname,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 15
        }
      }, hostData.hostname)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 20
        }
      }, "ip"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.ip: "${hostData.ip}"`,
        tooltipContent: hostData.ip,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 15
        }
      }, hostData.ip)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 20
        }
      }, "mac"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.mac: "${hostData.mac}"`,
        tooltipContent: hostData.mac,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 15
        }
      }, hostData.mac)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 20
        }
      }, "name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.name: "${hostData.name}"`,
        tooltipContent: hostData.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 15
        }
      }, hostData.name)
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "plain",
    hasBorder: false,
    borderRadius: "m",
    paddingSize: "none",
    css: stylesChild.metadataHostOS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    id: "hostOS",
    title: _i18n.i18n.translate('xpack.sessionView.metadataDetailsTab.host', {
      defaultMessage: 'OS'
    }),
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 24
        }
      }, "architecture"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.architecture: "${hostData.architecture}"`,
        tooltipContent: hostData.architecture,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 19
        }
      }, hostData.architecture)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 24
        }
      }, "os.family"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.family: "${hostData.os.family}"`,
        tooltipContent: hostData.os.family,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 19
        }
      }, hostData.os.family)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 24
        }
      }, "os.full"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.full: "${hostData.os.full}"`,
        tooltipContent: hostData.os.full,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 19
        }
      }, hostData.os.full)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 24
        }
      }, "os.kernel"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.kernel: "${hostData.os.kernel}"`,
        tooltipContent: hostData.os.kernel,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 19
        }
      }, hostData.os.kernel)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 24
        }
      }, "os.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.name: "${hostData.os.name}"`,
        tooltipContent: hostData.os.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 19
        }
      }, hostData.os.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 24
        }
      }, "os.platform"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.platform: "${hostData.os.platform}"`,
        tooltipContent: hostData.os.platform,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 19
        }
      }, hostData.os.platform)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 24
        }
      }, "os.version"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.version: "${hostData.os.version}"`,
        tooltipContent: hostData.os.version,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 196,
          columnNumber: 19
        }
      }, hostData.os.version)
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }))), processCloud && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    id: "metadataCloud",
    title: _i18n.i18n.translate('xpack.sessionView.metadataDetailsTab.cloud', {
      defaultMessage: 'Cloud'
    }),
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 24
        }
      }, "instance.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.provider: "${cloudData.instance.name}"`,
        tooltipContent: cloudData.instance.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 220,
          columnNumber: 19
        }
      }, cloudData.instance.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 24
        }
      }, "provider"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.provider: "${cloudData.provider}"`,
        tooltipContent: cloudData.provider,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 231,
          columnNumber: 19
        }
      }, cloudData.provider)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 240,
          columnNumber: 24
        }
      }, "region"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.region: "${cloudData.region}"`,
        tooltipContent: cloudData.region,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 242,
          columnNumber: 19
        }
      }, cloudData.region)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 251,
          columnNumber: 24
        }
      }, "account.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.account.id: "${cloudData.account.id}"`,
        tooltipContent: cloudData.account.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 253,
          columnNumber: 19
        }
      }, cloudData.account.id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 262,
          columnNumber: 24
        }
      }, "project.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.project.id: "${cloudData.project.id}"`,
        tooltipContent: cloudData.project.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 264,
          columnNumber: 19
        }
      }, cloudData.project.id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 273,
          columnNumber: 24
        }
      }, "project.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.project.name: "${cloudData.project.name}"`,
        tooltipContent: cloudData.project.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 19
        }
      }, cloudData.project.name)
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  })), processContainer && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    id: "metadataContainer",
    title: _i18n.i18n.translate('xpack.sessionView.metadataDetailsTab.container', {
      defaultMessage: 'Container'
    }),
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 24
        }
      }, "id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `container.id: "${containerData.id}"`,
        tooltipContent: containerData.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 298,
          columnNumber: 19
        }
      }, containerData.id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 24
        }
      }, "name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `container.name: "${containerData.name}"`,
        tooltipContent: containerData.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 309,
          columnNumber: 19
        }
      }, containerData.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 318,
          columnNumber: 24
        }
      }, "image.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `container.image.name: "${containerData.image.name}"`,
        tooltipContent: containerData.image.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 320,
          columnNumber: 19
        }
      }, containerData.image.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 329,
          columnNumber: 24
        }
      }, "image.tag"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `container.image.tag: "${containerData.image.tag}"`,
        tooltipContent: containerData.image.tag,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 331,
          columnNumber: 19
        }
      }, containerData.image.tag)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 340,
          columnNumber: 24
        }
      }, "image.hash.all"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `container.image.hash.all: "${containerData.image.hash.all}"`,
        tooltipContent: containerData.image.hash.all,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 342,
          columnNumber: 19
        }
      }, containerData.image.hash.all)
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  })), processOrchestrator && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    id: "metadataOrchestrator",
    title: _i18n.i18n.translate('xpack.sessionView.metadataDetailsTab.orchestrator', {
      defaultMessage: 'Orchestrator'
    }),
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 363,
          columnNumber: 24
        }
      }, "resource.ip"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.resource.ip: "${orchestratorData.resource.ip}"`,
        tooltipContent: orchestratorData.resource.ip,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 365,
          columnNumber: 19
        }
      }, orchestratorData.resource.ip)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 374,
          columnNumber: 24
        }
      }, "resource.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.resource.name: "${orchestratorData.resource.name}"`,
        tooltipContent: orchestratorData.resource.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 376,
          columnNumber: 19
        }
      }, orchestratorData.resource.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 385,
          columnNumber: 24
        }
      }, "resource.type"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.resource.type: "${orchestratorData.resource.type}"`,
        tooltipContent: orchestratorData.resource.type,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 387,
          columnNumber: 19
        }
      }, orchestratorData.resource.type)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 396,
          columnNumber: 24
        }
      }, "resource.parent.type"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.resource.parent.type: "${orchestratorData.resource.parent.type}"`,
        tooltipContent: orchestratorData.resource.parent.type,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 398,
          columnNumber: 19
        }
      }, orchestratorData.resource.parent.type)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 407,
          columnNumber: 24
        }
      }, "namespace"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.namespace: "${orchestratorData.namespace}"`,
        tooltipContent: orchestratorData.namespace,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 409,
          columnNumber: 19
        }
      }, orchestratorData.namespace)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 418,
          columnNumber: 24
        }
      }, "cluster.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.cluster.id: "${orchestratorData.cluster.id}"`,
        tooltipContent: orchestratorData.cluster.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 420,
          columnNumber: 19
        }
      }, orchestratorData.cluster.id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 429,
          columnNumber: 24
        }
      }, "cluster.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.cluster.name: "${orchestratorData.cluster.name}"`,
        tooltipContent: orchestratorData.cluster.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 431,
          columnNumber: 19
        }
      }, orchestratorData.cluster.name)
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 11
    }
  })));
};
exports.DetailPanelMetadataTab = DetailPanelMetadataTab;