"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfiguration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _searchConnectors = require("@kbn/search-connectors");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18n_string = require("../../../../../common/i18n_string");
var _connector_link = require("./connector_link");
var _connector_config_fields = require("./connector_config_fields");
var _connector_index_name = require("./connector_index_name");
var _connector_config_panels = require("./connector_config_panels");
var _connector_overview = require("./connector_overview");
var _connector_scheduling = require("../conector_scheduling_tab/connector_scheduling");
var _use_connectors = require("../../../hooks/api/use_connectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/serverless_search/public/application/components/connectors/connector_config/connector_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorConfiguration = ({
  connector
}) => {
  const {
    data
  } = (0, _use_connectors.useConnectors)();
  const {
    canManageConnectors
  } = data || {
    canManageConnectors: false
  };
  const [currentStep, setCurrentStep] = (0, _react.useState)('link');
  (0, _react.useEffect)(() => {
    let step = 'link';
    switch (connector.status) {
      case _searchConnectors.ConnectorStatus.CREATED:
        step = 'link';
        break;
      case _searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION:
        step = Object.keys(connector.configuration || {}).length > 0 ? 'configure' : 'link';
        break;
      case _searchConnectors.ConnectorStatus.CONFIGURED:
        step = 'connect';
        break;
      default:
        step = 'connected';
    }
    setCurrentStep(step);
  }, [connector.status, setCurrentStep, connector.configuration]);
  const steps = [{
    title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.linkToElasticTitle', {
      defaultMessage: 'Link to Elasticsearch'
    }),
    status: currentStep === 'link' ? 'current' : connector.status === _searchConnectors.ConnectorStatus.CREATED ? 'incomplete' : 'complete',
    onClick: () => setCurrentStep('link'),
    size: 's'
  }, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.configureTitle', {
      defaultMessage: 'Configure'
    }),
    status: currentStep === 'configure' ? 'current' : connector.status === _searchConnectors.ConnectorStatus.CONFIGURED || connector.status === _searchConnectors.ConnectorStatus.CONNECTED ? 'complete' : 'incomplete',
    onClick: () => setCurrentStep('configure'),
    size: 's'
  }, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectTitle', {
      defaultMessage: 'Connect Index'
    }),
    status: currentStep === 'connect' ? 'current' : connector.status === _searchConnectors.ConnectorStatus.CONNECTED && connector.index_name ? 'complete' : 'incomplete',
    onClick: () => setCurrentStep('connect'),
    size: 's'
  }];
  const tabs = [{
    content: /*#__PURE__*/_react.default.createElement(_connector_overview.ConnectorOverview, {
      canManageConnectors: canManageConnectors,
      connector: connector,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }),
    id: 'overview',
    name: _i18n_string.OVERVIEW_LABEL
  }, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_connector_config_panels.ConnectorConfigurationPanels, {
      canManageConnectors: canManageConnectors,
      connector: connector,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 11
      }
    })),
    id: 'configuration',
    name: _i18n_string.CONFIGURATION_LABEL
  }, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_connector_scheduling.ConnectorScheduling, {
      canManageConnectors: canManageConnectors,
      connector: connector,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    })),
    id: 'scheduling',
    name: _i18n_string.SCHEDULING_LABEL
  }];
  return currentStep === 'connected' ? /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    size: "s",
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, currentStep === 'link' && /*#__PURE__*/_react.default.createElement(_connector_link.ConnectorLinkElasticsearch, {
    connectorId: connector.id,
    serviceType: connector.service_type || '',
    status: connector.status,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }), currentStep === 'configure' && /*#__PURE__*/_react.default.createElement(_connector_config_fields.ConnectorConfigFields, {
    connector: connector,
    isDisabled: !canManageConnectors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }), currentStep === 'connect' && /*#__PURE__*/_react.default.createElement(_connector_index_name.ConnectorIndexName, {
    isDisabled: !canManageConnectors,
    connector: connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  })));
};
exports.ConnectorConfiguration = ConnectorConfiguration;