"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStackManagementNavigationTree = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _links = require("@kbn/security-solution-navigation/links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createStackManagementNavigationTree = ({
  sideNavVersion
} = {
  sideNavVersion: 'v1'
}) => ({
  id: 'category-management',
  title: _links.i18nStrings.projectSettings.title,
  icon: 'gear',
  breadcrumbStatus: 'hidden',
  renderAs: 'accordion',
  spaceBefore: null,
  sideNavVersion,
  children: [{
    id: 'stack_management',
    // This id can't be changed as we use it to open the panel programmatically
    title: _links.i18nStrings.stackManagement.title,
    renderAs: 'panelOpener',
    spaceBefore: null,
    children: [{
      title: _links.i18nStrings.stackManagement.data.title,
      breadcrumbStatus: 'hidden',
      children: [{
        link: 'management:index_management',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:transform',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:ingest_pipelines',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:dataViews',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:jobsListLink',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:pipelines',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:data_quality',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:data_usage',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:content_connectors',
        breadcrumbStatus: 'hidden'
      }]
    }, {
      title: _links.i18nStrings.stackManagement.access.title,
      breadcrumbStatus: 'hidden',
      children: [{
        link: 'management:api_keys',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:roles',
        breadcrumbStatus: 'hidden'
      }, {
        cloudLink: 'userAndRoles',
        title: _links.i18nStrings.stackManagement.access.usersAndRoles
      }]
    }, {
      title: _links.i18nStrings.stackManagement.alertsAndInsights.title,
      breadcrumbStatus: 'hidden',
      children: [{
        link: 'management:triggersActions',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:triggersActionsConnectors',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:maintenanceWindows',
        breadcrumbStatus: 'hidden'
      }, {
        id: _securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement)
      }, {
        id: _securitySolutionNavigation.SecurityPageName.entityAnalyticsEntityStoreManagement,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.entityAnalyticsEntityStoreManagement)
      }]
    }, {
      title: _links.i18nStrings.ml.title,
      children: [{
        link: 'management:overview'
      }, {
        link: 'management:anomaly_detection'
      }, {
        link: 'management:analytics'
      }, {
        link: 'management:trained_models'
      }, {
        link: 'management:supplied_configurations'
      }]
    }, {
      title: _links.i18nStrings.stackManagement.ai.title,
      breadcrumbStatus: 'hidden',
      children: [{
        link: 'management:genAiSettings',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:securityAiAssistantManagement',
        breadcrumbStatus: 'hidden'
      }]
    }, {
      title: _links.i18nStrings.stackManagement.content.title,
      breadcrumbStatus: 'hidden',
      children: [{
        link: 'management:spaces',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:objects',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:filesManagement',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:reporting',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'management:tags',
        breadcrumbStatus: 'hidden'
      }, {
        link: 'maps'
      }, {
        link: 'visualize'
      }]
    }, {
      title: _links.i18nStrings.stackManagement.other.title,
      breadcrumbStatus: 'hidden',
      children: [{
        link: 'management:settings',
        breadcrumbStatus: 'hidden'
      }]
    }]
  }, {
    id: `external-integrations`,
    link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.configurationsIntegrations)
  }, {
    cloudLink: 'billingAndSub'
  }]
});
exports.createStackManagementNavigationTree = createStackManagementNavigationTree;