"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateRuleUpgradeStatus = calculateRuleUpgradeStatus;
var _get_initial_usage = require("./get_initial_usage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function calculateRuleUpgradeStatus(upgradeableRules) {
  return upgradeableRules.reduce((acc, rule) => {
    acc.total += 1;
    if (rule.is_customized) {
      acc.customized += 1;
    }
    if (rule.enabled) {
      acc.enabled += 1;
    } else {
      acc.disabled += 1;
    }
    return acc;
  }, (0, _get_initial_usage.getInitialRuleUpgradeStatus)());
}