"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationTaskRunner = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _agent = require("./agent");
var _retrievers = require("./retrievers");
var _esql_knowledge_base = require("../../common/task/util/esql_knowledge_base");
var _siem_migrations_task_runner = require("../../common/task/siem_migrations_task_runner");
var _dashboard_migrations_telemetry_client = require("./dashboard_migrations_telemetry_client");
var _nullify_missing_properties = require("../../common/task/util/nullify_missing_properties");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DashboardMigrationTaskRunner extends _siem_migrations_task_runner.SiemMigrationTaskRunner {
  constructor(migrationId, request, startedBy, abortController, data, logger, dependencies) {
    super(migrationId, request, startedBy, abortController, data, logger, dependencies);
    (0, _defineProperty2.default)(this, "retriever", void 0);
    (0, _defineProperty2.default)(this, "taskConcurrency", 3);
    this.migrationId = migrationId;
    this.request = request;
    this.startedBy = startedBy;
    this.abortController = abortController;
    this.data = data;
    this.logger = logger;
    this.dependencies = dependencies;
    this.retriever = new _retrievers.DashboardMigrationsRetriever(this.migrationId, {
      data: this.data
    });
  }

  /** Retrieves the connector and creates the migration agent */
  async setup(connectorId) {
    const {
      inferenceService
    } = this.dependencies;
    const model = await this.actionsClientChat.createModel({
      connectorId,
      migrationId: this.migrationId,
      abortController: this.abortController
    });
    const modelName = this.actionsClientChat.getModelName(model);
    const telemetryClient = new _dashboard_migrations_telemetry_client.DashboardMigrationTelemetryClient(this.dependencies.telemetry, this.logger, this.migrationId, modelName);
    const esqlKnowledgeBase = new _esql_knowledge_base.EsqlKnowledgeBase(connectorId, this.migrationId, inferenceService.getClient({
      request: this.request
    }), this.logger);
    const agent = (0, _agent.getDashboardMigrationAgent)({
      model,
      esScopedClient: this.data.esScopedClient,
      esqlKnowledgeBase,
      dashboardMigrationsRetriever: this.retriever,
      logger: this.logger,
      telemetryClient,
      inference: inferenceService,
      request: this.request,
      connectorId
    });
    this.telemetry = telemetryClient;
    this.task = (input, config) => agent.invoke(input, config);
  }
  async initialize() {
    await this.retriever.initialize();
  }
  async prepareTaskInput(migrationDashboard) {
    const resources = await this.retriever.resources.getResources(migrationDashboard.original_dashboard);
    return {
      id: migrationDashboard.id,
      original_dashboard: migrationDashboard.original_dashboard,
      resources
    };
  }
  processTaskOutput(migrationDashboard, migrationOutput) {
    return {
      ...migrationDashboard,
      elastic_dashboard: (0, _nullify_missing_properties.nullifyMissingProperties)({
        source: migrationDashboard.elastic_dashboard,
        target: migrationOutput.elastic_dashboard
      }),
      translation_result: migrationOutput.translation_result,
      comments: migrationOutput.comments
    };
  }
}
exports.DashboardMigrationTaskRunner = DashboardMigrationTaskRunner;