"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemDashboardMigrationsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _assert = _interopRequireDefault(require("assert"));
var _dashboard_migrations_data_service = require("./data/dashboard_migrations_data_service");
var _dashboard_migrations_task_service = require("./task/dashboard_migrations_task_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SiemDashboardMigrationsService {
  constructor(logger, kibanaVersion, elserInferenceId) {
    (0, _defineProperty2.default)(this, "dataService", void 0);
    (0, _defineProperty2.default)(this, "esClusterClient", void 0);
    (0, _defineProperty2.default)(this, "taskService", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = logger.get('siemDashboardMigrations');
    this.dataService = new _dashboard_migrations_data_service.DashboardMigrationsDataService(this.logger, kibanaVersion);
    this.taskService = new _dashboard_migrations_task_service.DashboardMigrationsTaskService(this.logger);
  }
  setup({
    esClusterClient,
    ...params
  }) {
    this.esClusterClient = esClusterClient;
    const esClient = esClusterClient.asInternalUser;
    this.dataService.setup({
      ...params,
      esClient
    }).catch(err => {
      this.logger.error('Error installing data service.', err);
    });
  }
  createClient({
    request,
    currentUser,
    spaceId,
    dependencies
  }) {
    (0, _assert.default)(currentUser, 'Current user must be authenticated');
    (0, _assert.default)(this.esClusterClient, 'ES client not available, please call setup first');
    const esScopedClient = this.esClusterClient.asScoped(request);
    const dataClient = this.dataService.createClient({
      spaceId,
      currentUser,
      esScopedClient,
      dependencies
    });
    const taskClient = this.taskService.createClient({
      request,
      currentUser,
      dataClient,
      dependencies
    });
    return {
      data: dataClient,
      task: taskClient
    };
  }
  stop() {
    this.taskService.stopAll();
  }
}
exports.SiemDashboardMigrationsService = SiemDashboardMigrationsService;