"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConvertEsqlSchemaCisToEcs = void 0;
var _cim_ecs_map = require("./cim_ecs_map");
var _prompts = require("./prompts");
var _comments = require("../../../util/comments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConvertEsqlSchemaCisToEcs = ({
  esqlKnowledgeBase,
  logger
}) => {
  return async input => {
    var _response$match$, _response$match, _response$match$2, _response$match2;
    const esqlQuery = {
      title: input.title,
      description: input.description,
      query: input.query
    };
    const prompt = await _prompts.ESQL_CONVERT_CIM_TO_ECS_PROMPT.format({
      field_mapping: _cim_ecs_map.CIM_TO_ECS_MAP,
      spl_query: input.originalQuery,
      esql_query: JSON.stringify(esqlQuery, null, 2)
    });
    const response = await esqlKnowledgeBase.translate(prompt);
    const updatedQuery = (_response$match$ = (_response$match = response.match(/```esql\n([\s\S]*?)\n```/)) === null || _response$match === void 0 ? void 0 : _response$match[1]) !== null && _response$match$ !== void 0 ? _response$match$ : '';
    if (!updatedQuery) {
      logger.warn('Failed to apply ECS mapping to the query');
      const summary = '## Field Mapping Summary\n\nFailed to apply ECS mapping to the query';
      return {
        query: undefined,
        // No updated query if ECS mapping failed
        comments: [(0, _comments.generateAssistantComment)(summary)]
      };
    }
    const ecsSummary = (_response$match$2 = (_response$match2 = response.match(/## Field Mapping Summary[\s\S]*$/)) === null || _response$match2 === void 0 ? void 0 : _response$match2[0]) !== null && _response$match$2 !== void 0 ? _response$match$2 : '';

    // We set success to true to indicate that the ecs mapping has been applied.
    // This is to ensure that the node only runs once
    return {
      comments: [(0, _comments.generateAssistantComment)((0, _comments.cleanMarkdown)(ecsSummary))],
      query: updatedQuery
    };
  };
};
exports.getConvertEsqlSchemaCisToEcs = getConvertEsqlSchemaCisToEcs;