"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityStoreTaskLogMessageFactory = exports.entityStoreTaskLogFactory = exports.entityStoreTaskDebugLogFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityStoreTaskLogMessageFactory = taskId => message => {
  return `[Entity Store] [task ${taskId}]: ${message}`;
};
exports.entityStoreTaskLogMessageFactory = entityStoreTaskLogMessageFactory;
const entityStoreTaskLogFactory = (logger, taskId) => message => logger.info(`[Entity Store] [task ${taskId}]: ${message}`);
exports.entityStoreTaskLogFactory = entityStoreTaskLogFactory;
const entityStoreTaskDebugLogFactory = (logger, taskId) => message => logger.debug(`[Entity Store] [task ${taskId}]: ${message}`);
exports.entityStoreTaskDebugLogFactory = entityStoreTaskDebugLogFactory;