"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapEsqlAlerts = void 0;
var _lodash = require("lodash");
var _reason_formatters = require("../utils/reason_formatters");
var _transform_hit_to_alert = require("../factories/utils/transform_hit_to_alert");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const wrapEsqlAlerts = ({
  sharedParams,
  events,
  isRuleAggregating,
  expandedFields
}) => {
  const wrapped = events.map((event, i) => {
    var _event$_index;
    const id = (0, _utils.generateAlertId)({
      event,
      spaceId: sharedParams.spaceId,
      completeRule: sharedParams.completeRule,
      tuple: sharedParams.tuple,
      isRuleAggregating,
      index: i,
      expandedFields
    });
    const baseAlert = (0, _transform_hit_to_alert.transformHitToAlert)({
      sharedParams,
      doc: event,
      applyOverrides: true,
      buildReasonMessage: _reason_formatters.buildReasonMessageForNewTermsAlert,
      alertUuid: id
    });
    return {
      _id: id,
      _index: (_event$_index = event._index) !== null && _event$_index !== void 0 ? _event$_index : '',
      _source: baseAlert
    };
  });
  return (0, _lodash.uniqBy)(wrapped, alert => alert._id);
};
exports.wrapEsqlAlerts = wrapEsqlAlerts;