"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerActionListRoutes = registerActionListRoutes;
var _endpoint = require("../../../../common/api/endpoint");
var _constants = require("../../../../common/endpoint/constants");
var _list_handler = require("./list_handler");
var _with_endpoint_authz = require("../with_endpoint_authz");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Registers the endpoint activity_log route
 */
function registerActionListRoutes(router, endpointContext) {
  router.versioned.get({
    access: 'public',
    path: _constants.BASE_ENDPOINT_ACTION_ROUTE,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      authRequired: true
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: _endpoint.EndpointActionListRequestSchema
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    any: ['canReadActionsLogManagement', 'canAccessEndpointActionsLogManagement']
  }, endpointContext.logFactory.get('endpointActionList'), (0, _list_handler.actionListHandler)(endpointContext)));
}