"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateEsql = exports.extractEsqlFromContent = void 0;
var _esqlAst = require("@kbn/esql-ast");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateEsql = async (esClient, query) => {
  const {
    errors: parsingErrors
  } = (0, _esqlAst.parse)(query);
  if (!(0, _lodash.isEmpty)(parsingErrors)) {
    return {
      isValid: false,
      query,
      parsingErrors
    };
  }
  try {
    await esClient.esql.query({
      query: `${query}\n| LIMIT 0`,
      // Add a LIMIT 0 to minimize the risk of executing a costly query
      format: 'json'
    });
  } catch (executionError) {
    return {
      isValid: false,
      query,
      executionError
    };
  }
  return {
    isValid: true,
    query
  };
};
exports.validateEsql = validateEsql;
const extractEsqlFromContent = content => {
  const extractedEsql = [];
  let index = 0;
  while (index < content.length) {
    const start = content.indexOf('```esql', index);
    if (start === -1) {
      break;
    }
    const end = content.indexOf('```', start + 7);
    if (end === -1) {
      break;
    }
    extractedEsql.push(content.slice(start + 7, end).trim());
    index = end + 3;
  }
  return extractedEsql;
};
exports.extractEsqlFromContent = extractEsqlFromContent;