"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineColumns = void 0;
var _react = require("react");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _use_browser_fields = require("../../../../../data_view_manager/hooks/use_browser_fields");
var _model = require("../../../../../sourcerer/store/model");
var _containers = require("../../../../../sourcerer/containers");
var _default_config = require("../../../../../detections/components/alerts_table/default_config");
var _default_headers = require("../../body/column_headers/default_headers");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimelineColumns = columns => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    browserFields: oldBrowserFields
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(_model.SourcererScopeName.timeline);
  const browserFields = newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields;
  const localColumns = (0, _react.useMemo)(() => columns !== null && columns !== void 0 ? columns : _default_headers.defaultUdtHeaders, [columns]);
  const augmentedColumnHeaders = (0, _utils.memoizedGetTimelineColumnHeaders)(localColumns, browserFields, false);
  const timelineQueryFieldsFromColumns = (0, _react.useMemo)(() => {
    const columnFields = augmentedColumnHeaders.map(c => c.id);
    return [...columnFields, ..._default_config.requiredFieldsForActions];
  }, [augmentedColumnHeaders]);
  return (0, _react.useMemo)(() => ({
    defaultColumns: _default_headers.defaultUdtHeaders,
    localColumns,
    augmentedColumnHeaders,
    timelineQueryFieldsFromColumns
  }), [augmentedColumnHeaders, timelineQueryFieldsFromColumns, localColumns]);
};
exports.useTimelineColumns = useTimelineColumns;