"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNPINNED = exports.PINNED_WITH_NOTES = exports.PINNED = exports.DISABLE_PIN = exports.ATTACH_ALERT_TO_CASE_FOR_ROW = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNPINNED = isAlert => _i18n.i18n.translate('xpack.securitySolution.timeline.body.pinning.pinTooltip', {
  values: {
    isAlert
  },
  defaultMessage: 'Pin {isAlert, select, true{alert} other{event}}'
});
exports.UNPINNED = UNPINNED;
const PINNED = isAlert => _i18n.i18n.translate('xpack.securitySolution.timeline.body.pinning.unpinTooltip', {
  values: {
    isAlert
  },
  defaultMessage: 'Unpin {isAlert, select, true{alert} other{event}}'
});
exports.PINNED = PINNED;
const PINNED_WITH_NOTES = isAlert => _i18n.i18n.translate('xpack.securitySolution.timeline.body.pinning.pinnnedWithNotesTooltip', {
  values: {
    isAlert
  },
  defaultMessage: 'This {isAlert, select, true{alert} other{event}} cannot be unpinned because it has notes in Timeline'
});
exports.PINNED_WITH_NOTES = PINNED_WITH_NOTES;
const DISABLE_PIN = isAlert => _i18n.i18n.translate('xpack.securitySolution.timeline.body.pinning.disablePinnnedTooltip', {
  values: {
    isAlert
  },
  defaultMessage: 'This {isAlert, select, true{alert} other{event}} may not be pinned while editing a template timeline'
});
exports.DISABLE_PIN = DISABLE_PIN;
const ATTACH_ALERT_TO_CASE_FOR_ROW = ({
  ariaRowindex,
  columnValues
}) => _i18n.i18n.translate('xpack.securitySolution.timeline.body.actions.attachAlertToCaseForRowAriaLabel', {
  values: {
    ariaRowindex,
    columnValues
  },
  defaultMessage: 'Attach the alert or event in row {ariaRowindex} to a case, with columns {columnValues}'
});
exports.ATTACH_ALERT_TO_CASE_FOR_ROW = ATTACH_ALERT_TO_CASE_FOR_ROW;