"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zeekConnLogDictionay = exports.sha1StringRenderer = exports.moduleStringRenderer = exports.md5StringRenderer = exports.extractStateValue = exports.extractStateLink = exports.droppedStringRenderer = exports.defaultStringRenderer = exports.constructDroppedValue = exports.ZeekSignature = exports.TotalVirusLinkSha = exports.Link = exports.DraggableZeekElement = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggable_wrapper = require("../../../../../../common/components/drag_and_drop/draggable_wrapper");
var _helpers = require("../../../../../../common/components/drag_and_drop/helpers");
var _links = require("../../../../../../common/components/links");
var _data_provider = require("../../../data_providers/data_provider");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/zeek/zeek_signature.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Badge = (0, _styledComponents.default)(_eui.EuiBadge)`
  vertical-align: top;
`;
Badge.displayName = 'Badge';
const TokensFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: 3px;
`;
TokensFlexItem.displayName = 'TokensFlexItem';
const LinkFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: 6px;
`;
LinkFlexItem.displayName = 'LinkFlexItem';
const defaultStringRenderer = value => value;
exports.defaultStringRenderer = defaultStringRenderer;
const moduleStringRenderer = value => {
  const split = value.split('.');
  if (split.length >= 2 && split[1] != null) {
    if (split[1] !== '') {
      return split[1];
    } else {
      return split[0];
    }
  } else {
    return value;
  }
};
exports.moduleStringRenderer = moduleStringRenderer;
const droppedStringRenderer = value => `Dropped:${value}`;
exports.droppedStringRenderer = droppedStringRenderer;
const md5StringRenderer = value => `md5: ${value.substr(0, 7)}...`;
exports.md5StringRenderer = md5StringRenderer;
const sha1StringRenderer = value => `sha1: ${value.substr(0, 7)}...`;
exports.sha1StringRenderer = sha1StringRenderer;
const DraggableZeekElement = exports.DraggableZeekElement = /*#__PURE__*/_react.default.memo(({
  id,
  field,
  value,
  stringRenderer = defaultStringRenderer,
  scopeId
}) => {
  const dataProviderProp = (0, _react.useMemo)(() => ({
    and: [],
    enabled: true,
    id: (0, _helpers.escapeDataProviderId)(`draggable-zeek-element-draggable-wrapper-${id}-${field}-${value}`),
    name: String(value),
    excluded: false,
    kqlQuery: '',
    queryMatch: {
      field,
      value: String(value),
      operator: _data_provider.IS_OPERATOR
    }
  }), [field, id, value]);
  const render = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "badge-tooltip",
    content: field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Badge, {
    iconType: "tag",
    color: "hollow",
    title: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, stringRenderer(String(value)))), [field, stringRenderer, value]);
  return value != null ? /*#__PURE__*/_react.default.createElement(TokensFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_draggable_wrapper.DraggableWrapper, {
    scopeId: scopeId,
    dataProvider: dataProviderProp,
    render: render,
    isAggregatable: true,
    fieldType: 'keyword',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  })) : null;
});
DraggableZeekElement.displayName = 'DraggableZeekElement';
const Link = exports.Link = /*#__PURE__*/_react.default.memo(({
  value,
  link
}) => {
  if (value != null) {
    if (link != null) {
      return /*#__PURE__*/_react.default.createElement(LinkFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_links.GoogleLink, {
        link: link,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 13
        }
      }, value)));
    } else {
      return /*#__PURE__*/_react.default.createElement(LinkFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_links.GoogleLink, {
        link: value,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 13
        }
      })));
    }
  } else {
    return null;
  }
});
Link.displayName = 'Link';
const TotalVirusLinkSha = exports.TotalVirusLinkSha = /*#__PURE__*/_react.default.memo(({
  value
}) => value != null ? /*#__PURE__*/_react.default.createElement(LinkFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 152,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 153,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_links.ReputationLink, {
  domain: value,
  overflowIndexStart: 1,
  showDomain: true,
  "data-test-subj": "reputationLinkSha",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 154,
    columnNumber: 9
  }
}))) : null);
TotalVirusLinkSha.displayName = 'TotalVirusLinkSha';

// English Text for these codes are shortened from
// https://docs.zeek.org/en/stable/scripts/base/protocols/conn/main.bro.html
const zeekConnLogDictionay = exports.zeekConnLogDictionay = {
  S0: i18n.S0,
  S1: i18n.S1,
  S2: i18n.S2,
  S3: i18n.S3,
  SF: i18n.SF,
  REJ: i18n.REJ,
  RSTO: i18n.RSTO,
  RSTR: i18n.RSTR,
  RSTOS0: i18n.RSTOS0,
  RSTRH: i18n.RSTRH,
  SH: i18n.SH,
  SHR: i18n.SHR,
  OTH: i18n.OTH
};
const extractStateLink = state => {
  if (state != null) {
    const lookup = zeekConnLogDictionay[state];
    if (lookup != null) {
      return `${state} ${lookup}`;
    } else {
      return state;
    }
  } else {
    return null;
  }
};
exports.extractStateLink = extractStateLink;
const extractStateValue = state => state != null && zeekConnLogDictionay[state] != null ? zeekConnLogDictionay[state] : null;
exports.extractStateValue = extractStateValue;
const constructDroppedValue = dropped => dropped != null ? String(dropped) : null;
exports.constructDroppedValue = constructDroppedValue;
const ZeekSignature = exports.ZeekSignature = /*#__PURE__*/_react.default.memo(({
  data,
  timelineId
}) => {
  const id = `zeek-signature-draggable-zeek-element-${timelineId}-${data._id}`;
  const sessionId = (0, _fp.get)('zeek.session_id[0]', data);
  const dataSet = (0, _fp.get)('event.dataset[0]', data);
  const sslVersion = (0, _fp.get)('zeek.ssl.version[0]', data);
  const cipher = (0, _fp.get)('zeek.ssl.cipher[0]', data);
  const state = (0, _fp.get)('zeek.connection.state[0]', data);
  const history = (0, _fp.get)('zeek.connection.history[0]', data);
  const note = (0, _fp.get)('zeek.notice.note[0]', data);
  const noteMsg = (0, _fp.get)('zeek.notice.msg[0]', data);
  const dropped = constructDroppedValue((0, _fp.get)('zeek.notice.dropped[0]', data));
  const dnsQuery = (0, _fp.get)('zeek.dns.query[0]', data);
  const qClassName = (0, _fp.get)('zeek.dns.qclass_name[0]', data);
  const httpMethod = (0, _fp.get)('http.request.method[0]', data);
  const httpResponseStatusCode = (0, _fp.get)('http.response.status_code[0]', data);
  const urlOriginal = (0, _fp.get)('url.original[0]', data);
  const fileSha1 = (0, _fp.get)('zeek.files.sha1[0]', data);
  const filemd5 = (0, _fp.get)('zeek.files.md5[0]', data);
  const stateLink = extractStateLink(state);
  const stateValue = extractStateValue(state);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    scopeId: timelineId,
    id: id,
    field: "zeek.session_id",
    value: sessionId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "event.dataset",
    value: dataSet,
    stringRenderer: moduleStringRenderer,
    scopeId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.files.sha1",
    value: fileSha1,
    stringRenderer: sha1StringRenderer,
    scopeId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.files.md5",
    value: filemd5,
    stringRenderer: md5StringRenderer,
    scopeId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.notice.dropped",
    value: dropped,
    stringRenderer: droppedStringRenderer,
    scopeId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    scopeId: timelineId,
    id: id,
    field: "zeek.ssl.version",
    value: sslVersion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    scopeId: timelineId,
    id: id,
    field: "zeek.ssl.cipher",
    value: cipher,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    scopeId: timelineId,
    id: id,
    field: "zeek.connection.state",
    value: state,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    scopeId: timelineId,
    id: id,
    field: "http.request.method",
    value: httpMethod,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    scopeId: timelineId,
    id: id,
    field: "zeek.connection.history",
    value: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    scopeId: timelineId,
    id: id,
    field: "zeek.notice.note",
    value: note,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    scopeId: timelineId,
    id: id,
    field: "zeek.dns.query",
    value: dnsQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    scopeId: timelineId,
    id: id,
    field: "zeek.dns.qclass_name",
    value: qClassName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    scopeId: timelineId,
    id: id,
    field: "http.response.status_code",
    value: httpResponseStatusCode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Link, {
    link: stateLink,
    value: stateValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(Link, {
    value: cipher,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(Link, {
    value: dnsQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(Link, {
    value: noteMsg,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(Link, {
    value: urlOriginal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(TotalVirusLinkSha, {
    value: fileSha1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 9
    }
  })));
});
ZeekSignature.displayName = 'ZeekSignature';