"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemGenericLine = exports.SystemGenericDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var _helpers = require("../../../../../../common/components/tables/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _netflow = require("../netflow");
var _user_host_working_dir = require("../user_host_working_dir");
var _helpers2 = require("../helpers");
var _process_draggable = require("../process_draggable");
var _package = require("./package");
var _auth_ssh = require("./auth_ssh");
var _page = require("../../../../../../common/components/page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/system/generic_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SystemGenericLine = exports.SystemGenericLine = /*#__PURE__*/_react.default.memo(({
  contextId,
  hostName,
  id,
  message,
  outcome,
  packageName,
  packageSummary,
  packageVersion,
  processPid,
  processName,
  processExecutable,
  sshSignature,
  sshMethod,
  text,
  userDomain,
  userName,
  workingDirectory,
  scopeId
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "center",
  gutterSize: "none",
  wrap: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 68,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_user_host_working_dir.UserHostWorkingDir, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: id,
  hostName: hostName,
  userDomain: userDomain,
  userName: userName,
  workingDirectory: workingDirectory,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 69,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 9
  }
}, text), /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 81,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_process_draggable.ProcessDraggable, {
  scopeId: scopeId,
  contextId: contextId,
  endgamePid: undefined,
  endgameProcessName: undefined,
  eventId: id,
  processPid: processPid,
  processName: processName,
  processExecutable: processExecutable,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 82,
    columnNumber: 11
  }
})), outcome != null && /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 11
  }
}, i18n.WITH_RESULT), /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: id,
  field: "event.outcome",
  queryValue: outcome,
  value: outcome,
  isAggregatable: true,
  fieldType: "keyword",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_auth_ssh.AuthSsh, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: id,
  sshSignature: sshSignature,
  sshMethod: sshMethod,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 110,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_package.Package, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: id,
  packageName: packageName,
  packageSummary: packageSummary,
  packageVersion: packageVersion,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 117,
    columnNumber: 9
  }
})), message != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 128,
    columnNumber: 11
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "center",
  gutterSize: "none",
  wrap: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 129,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 130,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_page.Badge, {
  iconType: "editorComment",
  color: "hollow",
  title: "",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 131,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement(_helpers.OverflowField, {
  value: message,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 132,
    columnNumber: 17
  }
})))))));
SystemGenericLine.displayName = 'SystemGenericLine';
const SystemGenericDetails = exports.SystemGenericDetails = /*#__PURE__*/_react.default.memo(({
  contextId,
  data,
  text,
  timelineId
}) => {
  const id = data._id;
  const message = data.message != null ? data.message[0] : null;
  const hostName = (0, _fp.get)('host.name[0]', data);
  const userDomain = (0, _fp.get)('user.domain[0]', data);
  const userName = (0, _fp.get)('user.name[0]', data);
  const outcome = (0, _fp.get)('event.outcome[0]', data);
  const packageName = (0, _fp.get)('system.audit.package.name[0]', data);
  const packageSummary = (0, _fp.get)('system.audit.package.summary[0]', data);
  const packageVersion = (0, _fp.get)('system.audit.package.version[0]', data);
  const processPid = (0, _fp.get)('process.pid[0]', data);
  const processName = (0, _fp.get)('process.name[0]', data);
  const processExecutable = (0, _fp.get)('process.executable[0]', data);
  const sshSignature = (0, _fp.get)('system.auth.ssh.signature[0]', data);
  const sshMethod = (0, _fp.get)('system.auth.ssh.method[0]', data);
  const workingDirectory = (0, _fp.get)('process.working_directory[0]', data);
  return /*#__PURE__*/_react.default.createElement(_helpers2.Details, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SystemGenericLine, {
    scopeId: timelineId,
    contextId: contextId,
    hostName: hostName,
    id: id,
    message: message,
    outcome: outcome,
    packageName: packageName,
    packageSummary: packageSummary,
    packageVersion: packageVersion,
    processExecutable: processExecutable,
    processPid: processPid,
    processName: processName,
    sshMethod: sshMethod,
    sshSignature: sshSignature,
    text: text,
    userDomain: userDomain,
    userName: userName,
    workingDirectory: workingDirectory,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_netflow.NetflowRenderer, {
    data: data,
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }));
});
SystemGenericDetails.displayName = 'SystemGenericDetails';