"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgsComponent = exports.Args = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/args.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ArgsComponent = ({
  args,
  contextId,
  eventId,
  processTitle,
  scopeId
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(args) && (0, _helpers.isNillEmptyOrNotFinite)(processTitle)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, args != null && args.map((arg, i) => /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    key: `${contextId}-args-${i}-${arg}`,
    grow: false,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: `${contextId}-args-${i}-${arg}`,
    eventId: eventId,
    field: "process.args",
    value: arg,
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 13
    }
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(processTitle) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "process.title",
    value: processTitle,
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  })));
};
exports.ArgsComponent = ArgsComponent;
ArgsComponent.displayName = 'ArgsComponent';
const Args = exports.Args = /*#__PURE__*/_react.default.memo(ArgsComponent);
Args.displayName = 'Args';