"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineSaveStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _i18n = require("@kbn/i18n");
var _store = require("../../store");
var _defaults = require("../../store/defaults");
var _use_selector = require("../../../common/hooks/use_selector");
var _timeline = require("../../../../common/api/timeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/save_status/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UNSAVED = _i18n.i18n.translate('xpack.securitySolution.timeline.saveStatus.unsavedLabel', {
  defaultMessage: 'Unsaved'
});
const UNSAVED_CHANGES = _i18n.i18n.translate('xpack.securitySolution.timeline.saveStatus.unsavedChangesLabel', {
  defaultMessage: 'Unsaved changes'
});
/**
 * Show the save status of the timeline.
 * If the timeline is saved with no new changes, the component will not render anything.
 * If the timeline hasn't been saved yet or if it is in draft mode, the component will render 'Unsaved'.
 * If the timeline has new changes since last saved, the component will render 'Unsaved changed'.
 */
const TimelineSaveStatus = exports.TimelineSaveStatus = /*#__PURE__*/_react.default.memo(({
  timelineId
}) => {
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    changed = false,
    status,
    updated,
    show
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (0, _fp.pick)(['changed', 'status', 'updated', 'show'], (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults);
  });
  const isDraft = status === _timeline.TimelineStatusEnum.draft;
  const badgeColor = (0, _react.useMemo)(() => show ? 'warning' : 'default', [show]);
  let statusContent;
  if (isDraft || !updated) {
    statusContent = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: badgeColor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 21
      }
    }, UNSAVED);
  } else if (changed) {
    statusContent = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: badgeColor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 21
      }
    }, UNSAVED_CHANGES);
  }
  if (!statusContent) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "timeline-save-status",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, statusContent);
});
TimelineSaveStatus.displayName = 'TimelineSaveStatus';