"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _timeline = require("../../../../common/api/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../../containers/api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/open_timeline/use_timeline_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useTimelineStatus = ({
  timelineType,
  elasticTemplateTimelineCount,
  customTemplateTimelineCount
}) => {
  const [selectedTab, setSelectedTab] = (0, _react.useState)(null);
  const isTemplateFilterEnabled = (0, _react.useMemo)(() => timelineType === _timeline.TimelineTypeEnum.template, [timelineType]);
  const templateTimelineType = (0, _react.useMemo)(() => !isTemplateFilterEnabled ? null : selectedTab, [selectedTab, isTemplateFilterEnabled]);
  const timelineStatus = (0, _react.useMemo)(() => templateTimelineType == null ? null : templateTimelineType === _timeline.TemplateTimelineTypeEnum.elastic ? _timeline.TimelineStatusEnum.immutable : _timeline.TimelineStatusEnum.active, [templateTimelineType]);
  const filters = (0, _react.useMemo)(() => [{
    id: _timeline.TemplateTimelineTypeEnum.elastic,
    name: i18n.FILTER_ELASTIC_TIMELINES,
    disabled: !isTemplateFilterEnabled,
    withNext: true,
    count: elasticTemplateTimelineCount !== null && elasticTemplateTimelineCount !== void 0 ? elasticTemplateTimelineCount : undefined
  }, {
    id: _timeline.TemplateTimelineTypeEnum.custom,
    name: i18n.FILTER_CUSTOM_TIMELINES,
    disabled: !isTemplateFilterEnabled,
    withNext: false,
    count: customTemplateTimelineCount !== null && customTemplateTimelineCount !== void 0 ? customTemplateTimelineCount : undefined
  }], [customTemplateTimelineCount, elasticTemplateTimelineCount, isTemplateFilterEnabled]);
  const onFilterClicked = (0, _react.useCallback)(tabId => {
    if (selectedTab === tabId) {
      setSelectedTab(null);
    } else {
      setSelectedTab(tabId);
    }
  }, [setSelectedTab, selectedTab]);
  const templateTimelineFilter = (0, _react.useMemo)(() => {
    return isTemplateFilterEnabled ? filters.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      isToggle: true,
      isSelected: tab.id === templateTimelineType,
      hasActiveFilters: tab.id === templateTimelineType,
      key: `template-timeline-filter-${tab.id}`,
      numFilters: tab.count,
      onClick: onFilterClicked.bind(null, tab.id),
      withNext: tab.withNext,
      isDisabled: tab.disabled,
      "data-test-subj": tab.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 11
      }
    }, tab.name)) : null;
  }, [templateTimelineType, filters, isTemplateFilterEnabled, onFilterClicked]);
  const installPrepackagedTimelines = (0, _react.useCallback)(async () => {
    if (templateTimelineType !== _timeline.TemplateTimelineTypeEnum.custom) {
      await (0, _api.installPrepackedTimelines)();
    }
  }, [templateTimelineType]);
  return {
    timelineStatus,
    templateTimelineType,
    templateTimelineFilter,
    installPrepackagedTimelines
  };
};
exports.useTimelineStatus = useTimelineStatus;