"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchRow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../../common/api/timeline");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/open_timeline/search_row/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchRowContainer = _styledComponents.default.div`
  &:not(:last-child) {
    margin-bottom: ${props => props.theme.eui.euiSizeL};
  }
`;
SearchRowContainer.displayName = 'SearchRowContainer';
const SearchRowFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-bottom: ${props => props.theme.eui.euiSizeXS};
`;
SearchRowFlexGroup.displayName = 'SearchRowFlexGroup';
/**
 * Renders the row containing the search input and Only Favorites filter
 */
const SearchRow = exports.SearchRow = /*#__PURE__*/_react.default.memo(({
  favoriteCount,
  onlyFavorites,
  onQueryChange,
  onToggleOnlyFavorites,
  children,
  timelineType
}) => {
  const searchBox = (0, _react.useMemo)(() => ({
    placeholder: timelineType === _timeline.TimelineTypeEnum.default ? i18n.SEARCH_PLACEHOLDER : i18n.SEARCH_TEMPLATE_PLACEHOLDER,
    incremental: false,
    'data-test-subj': 'search-bar'
  }), [timelineType]);
  return /*#__PURE__*/_react.default.createElement(SearchRowContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SearchRowFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: searchBox,
    onChange: onQueryChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "only-favorites-toggle",
    isToggle: true,
    isSelected: onlyFavorites,
    hasActiveFilters: onlyFavorites,
    onClick: onToggleOnlyFavorites,
    numFilters: favoriteCount !== null && favoriteCount !== void 0 ? favoriteCount : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 17
    }
  }, i18n.ONLY_FAVORITES), !!children && children)))));
});
SearchRow.displayName = 'SearchRow';