"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorBlock = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _field_value = require("../common/field_value");
var _field_label = require("../common/field_label");
var _cell_actions = require("../../../../../common/components/cell_actions");
var _field_value2 = require("../../utils/field_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/flyout/block.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const panelProps = {
  color: 'subdued',
  hasShadow: false,
  borderRadius: 'none',
  paddingSize: 's'
};
/**
 * Renders indicator field value in a rectangle, to highlight it even more
 */
const IndicatorBlock = ({
  field,
  indicator,
  'data-test-subj': dataTestSubj
}) => {
  const {
    key,
    value
  } = (0, _field_value2.getIndicatorFieldAndValue)(indicator, field);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({}, panelProps, {
    "data-test-subj": `${dataTestSubj}Item`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: {
      field: key,
      value
    },
    mode: _cell_actions.CellActionsMode.HOVER_DOWN,
    triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_field_label.IndicatorFieldLabel, {
    field: field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_field_value.IndicatorFieldValue, {
    indicator: indicator,
    field: field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }))));
};
exports.IndicatorBlock = IndicatorBlock;