"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_MISSING_INDEX_PATTERN_SELECTED_RULES = exports.UPDATE_MISSING_INDEX_PATTERN_ARIA_LABEL = exports.UPDATE_MISSING_INDEX_PATTERN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPDATE_MISSING_INDEX_PATTERN = numberOfRulesWithMissingIndex => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.table.updateMissingIndexPattern', {
    defaultMessage: 'Update missing index pattern ({numberOfRulesWithMissingIndex})',
    values: {
      numberOfRulesWithMissingIndex
    }
  });
};
exports.UPDATE_MISSING_INDEX_PATTERN = UPDATE_MISSING_INDEX_PATTERN;
const UPDATE_MISSING_INDEX_PATTERN_ARIA_LABEL = exports.UPDATE_MISSING_INDEX_PATTERN_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.table.updateMissingIndexPatternButtonAriaLabel', {
  defaultMessage: 'Update missing index pattern'
});
const UPDATE_MISSING_INDEX_PATTERN_SELECTED_RULES = numberOfSelectedRules => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.table.updateMissingIndexPatternSelectedRules', {
    defaultMessage: 'Update selected missing index pattern ({numberOfSelectedRules})',
    values: {
      numberOfSelectedRules
    }
  });
};
exports.UPDATE_MISSING_INDEX_PATTERN_SELECTED_RULES = UPDATE_MISSING_INDEX_PATTERN_SELECTED_RULES;