"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLatestStats = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLatestStats = migrationService => {
  (0, _react.useEffect)(() => {
    migrationService.startPolling();
  }, [migrationService]);
  const refreshStats = (0, _react.useCallback)(() => {
    migrationService.getMigrationsStats(); // this updates latestStats$ internally
  }, [migrationService]);
  const latestStats$ = (0, _react.useMemo)(() => migrationService.getLatestStats$(), [migrationService]);
  const latestStats = (0, _useObservable.default)(latestStats$, null);
  return {
    data: latestStats !== null && latestStats !== void 0 ? latestStats : [],
    isLoading: latestStats === null,
    refreshStats
  };
};
exports.useLatestStats = useLatestStats;