"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOTAL_EXECUTION_TIME_TOOLTIP = exports.TOTAL_EXECUTION_TIME = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Translation for Total Execution Time in any provided format */
const TOTAL_EXECUTION_TIME = time => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.totalExecutionTime', {
  defaultMessage: 'Total execution time: {time}',
  values: {
    time
  }
});
exports.TOTAL_EXECUTION_TIME = TOTAL_EXECUTION_TIME;
const TOTAL_EXECUTION_TIME_TOOLTIP = itemTypes => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.totalExecutionTimeTooltip', {
  defaultMessage: 'The total amount of processing and re-processing time for translating the {itemTypes} in this migration',
  values: {
    itemTypes
  }
});
exports.TOTAL_EXECUTION_TIME_TOOLTIP = TOTAL_EXECUTION_TIME_TOOLTIP;