"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatsDetected = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _threats_detected_metric = require("./threats_detected_metric");
var _compare_percentage = require("./compare_percentage");
var _metrics = require("./metrics");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/threats_detected.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ThreatsDetected = ({
  attackDiscoveryCount,
  attackDiscoveryCountCompare,
  from,
  to
}) => {
  return /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
        min-height: 160px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_threats_detected_metric.ThreatsDetectedMetric, {
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_compare_percentage.ComparePercentage, {
    currentCount: attackDiscoveryCount,
    positionForLens: true,
    previousCount: attackDiscoveryCountCompare,
    stat: `${attackDiscoveryCountCompare}`,
    statType: i18n.ATTACK_DISCOVERY_COUNT,
    timeRange: (0, _metrics.getTimeRangeAsDays)({
      from,
      to
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }));
};
exports.ThreatsDetected = ThreatsDetected;