"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulOverview = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../../app/translations");
var _constants = require("../../common/store/inputs/constants");
var _filters_global = require("../../common/components/filters_global");
var _search_bar = require("../../common/components/search_bar");
var _page_wrapper = require("../../common/components/page_wrapper");
var _use_global_time = require("../../common/containers/use_global_time");
var _source = require("../../common/containers/source");
var _events_by_dataset = require("../components/events_by_dataset");
var _event_counts = require("../components/event_counts");
var _sidebar = require("../components/sidebar");
var _signals_by_category = require("../components/signals_by_category");
var _store = require("../../common/store");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _types = require("../../app/types");
var _endpoint_notice = require("../components/endpoint_notice");
var _use_messages_storage = require("../../common/containers/local_storage/use_messages_storage");
var _constants2 = require("../../../common/constants");
var _containers = require("../../sourcerer/containers");
var _use_selector = require("../../common/hooks/use_selector");
var _overview_cti_links = require("../components/overview_cti_links");
var _use_all_ti_data_sources = require("../containers/overview_cti_links/use_all_ti_data_sources");
var _user_privileges = require("../../common/components/user_privileges");
var _use_alerts_privileges = require("../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _empty_prompt = require("../../common/components/empty_prompt");
var _use_selected_patterns = require("../../data_view_manager/hooks/use_selected_patterns");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _page_loader = require("../../common/components/page_loader");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/pages/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OverviewComponent = () => {
  var _experimentalDataView;
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    from,
    deleteQuery,
    setQuery,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    indicesExist: oldIndicesExist,
    sourcererDataView: oldSourcererDataView,
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)();
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)();
  const indicesExist = newDataViewPickerEnabled ? !!((_experimentalDataView = experimentalDataView.matchedIndices) !== null && _experimentalDataView !== void 0 && _experimentalDataView.length) : oldIndicesExist;
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const endpointMetadataIndex = (0, _react.useMemo)(() => {
    return [_constants2.ENDPOINT_METADATA_INDEX];
  }, []);
  const [, {
    indexExists: metadataIndexExists
  }] = (0, _source.useFetchIndex)(endpointMetadataIndex, true);
  const {
    addMessage,
    hasMessage
  } = (0, _use_messages_storage.useMessagesStorage)();
  const hasDismissEndpointNoticeMessage = (0, _react.useMemo)(() => hasMessage('management', 'dismissEndpointNotice'), [hasMessage]);
  const [dismissMessage, setDismissMessage] = (0, _react.useState)(hasDismissEndpointNoticeMessage);
  const dismissEndpointNotice = (0, _react.useCallback)(() => {
    setDismissMessage(true);
    addMessage('management', 'dismissEndpointNotice');
  }, [addMessage]);
  const {
    endpointPrivileges: {
      canAccessFleet
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    hasIndexRead,
    hasKibanaREAD
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const {
    tiDataSources: allTiDataSources,
    isInitiallyLoaded: isTiLoaded
  } = (0, _use_all_ti_data_sources.useAllTiDataSources)();
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, _translations.OVERVIEW)), indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    sourcererDataView: newDataViewPickerEnabled ? experimentalDataView : oldSourcererDataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, !dismissMessage && !metadataIndexExists && canAccessFleet && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_endpoint_notice.EndpointNotice, {
    onDismiss: dismissEndpointNotice,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['xl'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_sidebar.StatefulSidebar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 17
    }
  }, hasIndexRead && hasKibanaREAD && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_signals_by_category.SignalsByCategory, {
    filters: filters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_events_by_dataset.EventsByDataset, {
    deleteQuery: deleteQuery,
    filters: filters,
    from: from,
    dataViewSpec: oldSourcererDataView,
    dataView: experimentalDataView,
    query: query,
    queryType: "overview",
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_event_counts.EventCounts, {
    filters: filters,
    from: from,
    indexNames: selectedPatterns,
    dataViewSpec: oldSourcererDataView,
    dataView: experimentalDataView,
    query: query,
    setQuery: setQuery,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 23
    }
  }, isTiLoaded && /*#__PURE__*/_react.default.createElement(_overview_cti_links.ThreatIntelLinkPanel, {
    allTiDataSources: allTiDataSources,
    deleteQuery: deleteQuery,
    from: from,
    setQuery: setQuery,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 27
    }
  }))))))))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.overview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }));
};
const StatefulOverview = exports.StatefulOverview = /*#__PURE__*/_react.default.memo(OverviewComponent);